package com.biz.crm.mdm.business.warehouse.sdk.event;


import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseEventVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 仓库变更事件通知接口
 *
 * @author ning.zhang
 * @date 2021/10/27
 */
public interface WarehouseEventListener extends NebulaEvent {

  /**
   * 当仓库创建时触发
   *
   * @param vo 创建时的vo
   */
  void onCreate(WarehouseEventVo vo);

  /**
   * 当仓库修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(WarehouseEventVo vo);

  /**
   * 当仓库禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(WarehouseEventVo vo);

  /**
   * 当仓库启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(WarehouseEventVo vo);

  /**
   * 当仓库删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(WarehouseEventVo vo);

}
