package com.biz.crm.mdm.business.warehouse.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 仓库事件Vo
 *
 * @author ning.zhang
 * @date 2021/10/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class WarehouseVo extends UuidFlagOpVo {

  private static final long serialVersionUID = 6037874681429995596L;

  /**
   * 仓库名称
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 仓库编码
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库地址
   */
  @ApiModelProperty("仓库地址")
  private String warehouseAddress;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 仓库责任人
   */
  @ApiModelProperty("仓库责任人")
  private String warehouseHead;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  private String contactPhone;

  /**
   * 默认仓库(true:是,false:否)
   */
  @ApiModelProperty("默认仓库(true:是,false:否)")
  private Boolean warehouseDefault;

  /**
   * 仓库状态
   */
  @ApiModelProperty("仓库状态")
  private String enableStatus;
}
