package com.biz.crm.mdm.business.competence.workflow.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;

/**
 * 工作流扩展单位 的 mybatis-plus接口类 {@link WorkflowCompetenceEntity}
 *
 * @author jerry7
 */
public interface WorkflowCompetenceMapper extends BaseMapper<WorkflowCompetenceEntity> {

  /**
   * 按照功能业务编号，查询具体的业务功能信息
   *
   * @param competenceCode 业务编号
   * @return 菜单实体
   */
  WorkflowCompetenceEntity findByCompetenceCode(@Param("competenceCode") String competenceCode);

  /**
   * 按照功能业务编号，查询具体的业务功能信息
   *
   * @param competenceCodes 业务编号
   * @return 菜单实体
   */
  Set<WorkflowCompetenceEntity> findByCompetenceCodes(@Param("competenceCodes") List<String> competenceCodes);
  
}
