package com.biz.crm.mdm.business.competence.workflow.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import com.biz.crm.mdm.business.competence.workflow.mapper.WorkflowCompetenceMapper;
import com.bizunited.nebula.competence.tacit.local.entity.DefaultCompetenceEntity;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 工作流扩展菜单 的 数据库访问类 {@link WorkflowCompetenceEntity}
 *
 * @author jerry7
 */
@Component
public class WorkflowCompetenceRepository extends ServiceImpl<WorkflowCompetenceMapper, WorkflowCompetenceEntity> {

  /**
   * 按照功能业务编号，查询具体的业务功能信息
   *
   * @param competenceCode 业务编码
   * @return 菜单信息
   */
  public WorkflowCompetenceEntity findByCompetenceCode(String competenceCode) {
    return this.baseMapper.findByCompetenceCode(competenceCode);
  }

  /**
   * 按照功能业务列表，查询具体的业务功能信息
   *
   * @param competenceCodes 业务编码列表
   * @return 菜单信息
   */
  public Set<WorkflowCompetenceEntity> findByCompetenceCodes(@Param("competenceCodes") List<String> competenceCodes) {
    return this.baseMapper.findByCompetenceCodes(competenceCodes);
  }
}
