package com.biz.crm.mdm.business.competence.workflow.service.register;

import com.biz.crm.mdm.business.competence.workflow.WorkflowCompetenceVo;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import com.biz.crm.mdm.business.competence.workflow.repository.WorkflowCompetenceRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.competence.tacit.local.vo.DefaultButtonVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * 默认的功能、按钮管理实现模块的注册实现
 * 
 * @author yinwenjie
 */
@Component
public class WorkflowCompetenceRegister
    implements
      CompetenceRegister<WorkflowCompetenceVo, DefaultButtonVo> {

  private static final String WORKFLOW_TYPE = "workflow";
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private WorkflowCompetenceRepository workflowCompetenceRepository;

  @Override
  public String getType() {
    return WORKFLOW_TYPE;
  }

  @Override
  public String getComment() {
    return "工作流扩展菜单";
  }

  @Override
  public Class<WorkflowCompetenceVo> getCompetenceClass() {
    return WorkflowCompetenceVo.class;
  }

  @Override
  public Class<DefaultButtonVo> getButtonClass() {
    return DefaultButtonVo.class;
  }

  @Override
  public WorkflowCompetenceVo cloneCompetence(CompetenceVo sourceCompetence) {
    WorkflowCompetenceVo sourceDefaultCompetence = (WorkflowCompetenceVo) sourceCompetence;
    // 只做自身的copy，不做任何关联信息（下级菜单/功能、关联按钮）的copy
    WorkflowCompetenceVo copyDefaultCompetence = this.nebulaToolkitService.copyObjectByWhiteList(sourceDefaultCompetence, WorkflowCompetenceVo.class, LinkedHashSet.class, ArrayList.class);
    // 然后是可能的按钮信息
    List<ButtonVo> buttonVos = sourceDefaultCompetence.getButtons();
    List<ButtonVo> copyButtons = Lists.newArrayList();
    if(!CollectionUtils.isEmpty(buttonVos)) {
      for (ButtonVo buttonVo : buttonVos) {
        copyButtons.add(this.nebulaToolkitService.copyObjectByWhiteList(buttonVo, buttonVo.getClass(), LinkedHashSet.class, ArrayList.class));
      }
      copyDefaultCompetence.setButtons(copyButtons);
    }
    return copyDefaultCompetence;
  }

  @Override
  public DefaultButtonVo cloneButton(ButtonVo sourceButton) {
    DefaultButtonVo sourceDefaultButton = (DefaultButtonVo)sourceButton;
    // 只做自身的copy
    return this.nebulaToolkitService.copyObjectByBlankList(sourceDefaultButton, DefaultButtonVo.class, LinkedHashSet.class, ArrayList.class);
  }

  @Override
  public Set<DefaultButtonVo> onRequestButtonVos(List<String> buttonCodes) {
    // 默认按钮无需进行多余信息构建
    Set<DefaultButtonVo> defaultButtonVos = Sets.newLinkedHashSet();
    for (String buttonCode : buttonCodes) {
      DefaultButtonVo defaultButtonVo = new DefaultButtonVo();
      defaultButtonVo.setCode(buttonCode);
      defaultButtonVo.setButtonCode(buttonCode);
      defaultButtonVos.add(defaultButtonVo);
    }
    return defaultButtonVos;
  }

  @Override
  public Set<WorkflowCompetenceVo> onRequestCompetenceVos(List<String> competenceCodes) {
    Set<WorkflowCompetenceEntity> defaultCompetences = this.workflowCompetenceRepository.findByCompetenceCodes(competenceCodes);
    if(CollectionUtils.isEmpty(defaultCompetences)) {
      return Sets.newLinkedHashSet();
    }
    
    // 开始进行转换(只处理DefaultCompetenceVo中的扩展信息即可)
    Set<WorkflowCompetenceVo> workflowCompetenceVos = Sets.newLinkedHashSet();
    for (WorkflowCompetenceEntity workflowCompetenceEntity : defaultCompetences) {
      WorkflowCompetenceVo workflowCompetenceVo = new WorkflowCompetenceVo();
      workflowCompetenceVo.setCode(workflowCompetenceEntity.getCompetenceCode());
      workflowCompetenceVo.setCompetenceCode(workflowCompetenceEntity.getCompetenceCode());
      workflowCompetenceVo.setExtractUri(workflowCompetenceEntity.getExtractUri());
      workflowCompetenceVo.setMethods(workflowCompetenceEntity.getMethods());
      workflowCompetenceVo.setTag(workflowCompetenceEntity.getTag());
      workflowCompetenceVo.setRelationBillCode(workflowCompetenceEntity.getRelationBillCode());
      workflowCompetenceVos.add(workflowCompetenceVo);
    }
    return workflowCompetenceVos;
  }

  @Override
  public boolean matchedResources(CompetenceVo competence, String resource, String method, boolean like, String tenantCode) {
    WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo) competence;
    String targetResource = workflowCompetenceVo.getResource();
    String targetMethods = workflowCompetenceVo.getMethods();
    Integer targetStatus = workflowCompetenceVo.getTstatus();
    
    if(StringUtils.isAnyBlank(targetResource , targetMethods) || targetStatus == null) {
      return false;
    } 
    // 比较可能的方法类型
    if(!StringUtils.isBlank(method) && StringUtils.indexOf(targetMethods, method) == -1) {
      return false;
    }
    
    // 如果条件成立那么使用精确匹配，否则就是模糊匹配
    if(!like && StringUtils.equals(resource, targetResource)) {
      return true;
    } else if(like && StringUtils.indexOf(resource, targetResource) != -1) {
      return true;
    }
    return false;
  }

  @Override
  public boolean matchedResources(CompetenceVo competence, RequestMappingInfo requestMappingInfo, String tenantCode, HttpServletRequest request) {
    WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo) competence;
    String methods = workflowCompetenceVo.getMethods();
    String currentMethod = request.getMethod();
    String matchedFix = tenantCode + "|";
    
    // 默认的实现中，只确定method type的信息匹配、并且二级租户信息匹配要求就行了
    if(methods.indexOf(currentMethod) == -1) {
      return false;
    }
    // 取得当前功能和角色的绑定关系(注意这里每一条信息都是tenantCode|roleCode)，且使用“|”进行了分割
    Set<String> tenantAndRoleCodes = competence.getRoleCodes();
    if(CollectionUtils.isEmpty(tenantAndRoleCodes)) {
      return false;
    }
    // 将角色添加到返回值中，证明当前系统中已设定当前角色可以访该功能
    // 每一条记录都是由tenantCode|roleCode构成
    for (String tenantAndRoleCode: tenantAndRoleCodes) {
      if(StringUtils.indexOf(tenantAndRoleCode, matchedFix) != 0) {
        return true;
      }
    }
    return false;
  }
}
