/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.competence.workflow.service.event;

import com.biz.crm.mdm.business.competence.workflow.WorkflowCompetenceVo;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import com.biz.crm.mdm.business.competence.workflow.repository.WorkflowCompetenceRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.event.CompetenceEventListener;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.competence.tacit.local.entity.DefaultCompetenceEntity;
import com.bizunited.nebula.competence.tacit.local.repository.DefaultCompetenceRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCompetenceEventListener
implements CompetenceEventListener {
    @Autowired(required=false)
    private WorkflowCompetenceRepository workflowCompetenceRepository;
    @Autowired(required=false)
    private DefaultCompetenceRepository defaultCompetenceRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void onCreated(CompetenceVo competence) {
        if (!(competence instanceof WorkflowCompetenceVo)) {
            return;
        }
        WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo)competence;
        String competenceCode = workflowCompetenceVo.getCode();
        WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
        Validate.isTrue((exsit == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9ed8\u8ba4\u529f\u80fd\u4e2d\u5df2\u7ecf\u5173\u8054\u4e86\u5bf9\u5e94\u7684\u529f\u80fd\u57fa\u672c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        WorkflowCompetenceEntity workflowCompetenceEntity = new WorkflowCompetenceEntity();
        workflowCompetenceEntity.setExtractUri(workflowCompetenceVo.getExtractUri());
        workflowCompetenceEntity.setMethods(workflowCompetenceVo.getMethods());
        workflowCompetenceEntity.setCompetenceCode(competenceCode);
        workflowCompetenceEntity.setRelationBillCode(workflowCompetenceVo.getRelationBillCode());
        if (StringUtils.isBlank((CharSequence)workflowCompetenceVo.getTag())) {
            workflowCompetenceEntity.setTag("");
        } else {
            workflowCompetenceEntity.setTag(workflowCompetenceVo.getTag());
        }
        this.workflowCompetenceRepository.save((Object)workflowCompetenceEntity);
    }

    public void onUpdate(CompetenceVo competence) {
        if (!(competence instanceof WorkflowCompetenceVo)) {
            return;
        }
        WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo)competence;
        String competenceCode = workflowCompetenceVo.getCode();
        WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
        if (ObjectUtils.isEmpty((Object)((Object)exsit))) {
            DefaultCompetenceEntity defaultEntity = this.defaultCompetenceRepository.findByCompetenceCode(competenceCode);
            Validate.isTrue((defaultEntity != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9ed8\u8ba4\u529f\u80fd\u4e2d\u4e0d\u5b58\u5728\u5165\u53c2\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            exsit = (WorkflowCompetenceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)defaultEntity, WorkflowCompetenceEntity.class, HashSet.class, ArrayList.class, new String[0]));
        }
        exsit.setExtractUri(workflowCompetenceVo.getExtractUri());
        exsit.setMethods(workflowCompetenceVo.getMethods());
        exsit.setRelationBillCode(workflowCompetenceVo.getRelationBillCode());
        exsit.setCompetenceCode(competenceCode);
        if (StringUtils.isBlank((CharSequence)workflowCompetenceVo.getTag())) {
            exsit.setTag("");
        } else {
            exsit.setTag(workflowCompetenceVo.getTag());
        }
        this.workflowCompetenceRepository.saveOrUpdate((Object)exsit);
    }

    public void onDeleted(CompetenceVo competence) {
        if (!(competence instanceof WorkflowCompetenceVo)) {
            return;
        }
        String competenceCode = competence.getCode();
        WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
        Validate.notNull((Object)((Object)exsit), (String)"\u5220\u9664\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9ed8\u8ba4\u529f\u80fd\u4e2d\u6ca1\u6709\u5173\u8054\u5bf9\u5e94\u7684\u529f\u80fd\u57fa\u672c\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.workflowCompetenceRepository.removeById((Serializable)((Object)exsit.getId()));
    }
}

