/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.competence.workflow.service.register;

import com.biz.crm.mdm.business.competence.workflow.WorkflowCompetenceVo;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import com.biz.crm.mdm.business.competence.workflow.repository.WorkflowCompetenceRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.competence.tacit.local.vo.DefaultButtonVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@Component
public class WorkflowCompetenceRegister
implements CompetenceRegister<WorkflowCompetenceVo, DefaultButtonVo> {
    private static final String WORKFLOW_TYPE = "workflow";
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private WorkflowCompetenceRepository workflowCompetenceRepository;

    public String getType() {
        return WORKFLOW_TYPE;
    }

    public String getComment() {
        return "\u5de5\u4f5c\u6d41\u6269\u5c55\u83dc\u5355";
    }

    public Class<WorkflowCompetenceVo> getCompetenceClass() {
        return WorkflowCompetenceVo.class;
    }

    public Class<DefaultButtonVo> getButtonClass() {
        return DefaultButtonVo.class;
    }

    public WorkflowCompetenceVo cloneCompetence(CompetenceVo sourceCompetence) {
        WorkflowCompetenceVo sourceDefaultCompetence = (WorkflowCompetenceVo)sourceCompetence;
        WorkflowCompetenceVo copyDefaultCompetence = (WorkflowCompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)sourceDefaultCompetence, WorkflowCompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List buttonVos = sourceDefaultCompetence.getButtons();
        ArrayList copyButtons = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)buttonVos)) {
            for (ButtonVo buttonVo : buttonVos) {
                copyButtons.add(this.nebulaToolkitService.copyObjectByWhiteList((Object)buttonVo, buttonVo.getClass(), LinkedHashSet.class, ArrayList.class, new String[0]));
            }
            copyDefaultCompetence.setButtons((List)copyButtons);
        }
        return copyDefaultCompetence;
    }

    public DefaultButtonVo cloneButton(ButtonVo sourceButton) {
        DefaultButtonVo sourceDefaultButton = (DefaultButtonVo)sourceButton;
        return (DefaultButtonVo)this.nebulaToolkitService.copyObjectByBlankList((Object)sourceDefaultButton, DefaultButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public Set<DefaultButtonVo> onRequestButtonVos(List<String> buttonCodes) {
        LinkedHashSet defaultButtonVos = Sets.newLinkedHashSet();
        for (String buttonCode : buttonCodes) {
            DefaultButtonVo defaultButtonVo = new DefaultButtonVo();
            defaultButtonVo.setCode(buttonCode);
            defaultButtonVo.setButtonCode(buttonCode);
            defaultButtonVos.add(defaultButtonVo);
        }
        return defaultButtonVos;
    }

    public Set<WorkflowCompetenceVo> onRequestCompetenceVos(List<String> competenceCodes) {
        Set<WorkflowCompetenceEntity> defaultCompetences = this.workflowCompetenceRepository.findByCompetenceCodes(competenceCodes);
        if (CollectionUtils.isEmpty(defaultCompetences)) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet workflowCompetenceVos = Sets.newLinkedHashSet();
        for (WorkflowCompetenceEntity workflowCompetenceEntity : defaultCompetences) {
            WorkflowCompetenceVo workflowCompetenceVo = new WorkflowCompetenceVo();
            workflowCompetenceVo.setCode(workflowCompetenceEntity.getCompetenceCode());
            workflowCompetenceVo.setCompetenceCode(workflowCompetenceEntity.getCompetenceCode());
            workflowCompetenceVo.setExtractUri(workflowCompetenceEntity.getExtractUri());
            workflowCompetenceVo.setMethods(workflowCompetenceEntity.getMethods());
            workflowCompetenceVo.setTag(workflowCompetenceEntity.getTag());
            workflowCompetenceVo.setRelationBillCode(workflowCompetenceEntity.getRelationBillCode());
            workflowCompetenceVos.add(workflowCompetenceVo);
        }
        return workflowCompetenceVos;
    }

    public boolean matchedResources(CompetenceVo competence, String resource, String method, boolean like, String tenantCode) {
        WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo)competence;
        String targetResource = workflowCompetenceVo.getResource();
        String targetMethods = workflowCompetenceVo.getMethods();
        Integer targetStatus = workflowCompetenceVo.getTstatus();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{targetResource, targetMethods}) || targetStatus == null) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)method) && StringUtils.indexOf((CharSequence)targetMethods, (CharSequence)method) == -1) {
            return false;
        }
        if (!like && StringUtils.equals((CharSequence)resource, (CharSequence)targetResource)) {
            return true;
        }
        return like && StringUtils.indexOf((CharSequence)resource, (CharSequence)targetResource) != -1;
    }

    public boolean matchedResources(CompetenceVo competence, RequestMappingInfo requestMappingInfo, String tenantCode, HttpServletRequest request) {
        WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo)competence;
        String methods = workflowCompetenceVo.getMethods();
        String currentMethod = request.getMethod();
        String matchedFix = tenantCode + "|";
        if (methods.indexOf(currentMethod) == -1) {
            return false;
        }
        Set tenantAndRoleCodes = competence.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)tenantAndRoleCodes)) {
            return false;
        }
        for (String tenantAndRoleCode : tenantAndRoleCodes) {
            if (StringUtils.indexOf((CharSequence)tenantAndRoleCode, (CharSequence)matchedFix) == 0) continue;
            return true;
        }
        return false;
    }
}

