package com.biz.crm.mdm.business.competence.workflow.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author jerry7
 * 单位扩展-工作流
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetenceWorkflow", description = "单位扩展-工作流实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`competence_workflow`", comment = "单位扩展-工作流实体类")
@TableName("competence_workflow")
@Table(name = "`competence_workflow`", indexes = @Index(name = "competence_code", columnList = "competence_code", unique = true))
public class WorkflowCompetenceEntity extends UuidEntity {
  private static final long serialVersionUID = 8599246341788262253L;

  /**
   * 对应的功能模块的业务编号信息（唯一存在）
   */
  @ApiModelProperty(name = "competenceCode", value = "对应的功能模块的业务编号信息（唯一存在）")
  @Column(name = "competence_code", nullable = false, columnDefinition = "varchar(255) COMMENT '对应的功能模块的业务编号信息（唯一存在）'")
  private String competenceCode;
  /**
   * 涉及的方法描述。例如：POST或者POST|GET|DELETE
   */
  @ApiModelProperty(name = "methods", value = "涉及的方法描述，例如：POST或者POST|GET|DELETE", required = true)
  @Column(name = "methods", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '涉及的方法描述'")
  private String methods = "";
  /**
   * 这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径
   */
  @Column(name = "extract_uri", nullable = false, columnDefinition = "int(11) COMMENT '这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径'")
  private Integer extractUri = 0;
  /**
   * 标签
   **/
  @ApiModelProperty(name = "tag", value = "标签")
  @Column(name = "tag", columnDefinition = "varchar(255) COMMENT '标签'")
  private String tag;

  /**
   * 关联单据编码(扩展字段)
   **/
  @ApiModelProperty(name = "relationBillCode", value = "关联单据编码")
  @Column(name = "relation_bill_code", columnDefinition = "varchar(255) COMMENT '关联单据编码'")
  private String relationBillCode;
}
