package com.biz.crm.mdm.business.competence.workflow.service.event;

import com.biz.crm.mdm.business.competence.workflow.WorkflowCompetenceVo;
import com.biz.crm.mdm.business.competence.workflow.entity.WorkflowCompetenceEntity;
import com.biz.crm.mdm.business.competence.workflow.repository.WorkflowCompetenceRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.event.CompetenceEventListener;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.competence.tacit.local.entity.DefaultCompetenceEntity;
import com.bizunited.nebula.competence.tacit.local.repository.DefaultCompetenceRepository;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * 工作流扩展菜单event监听
 *
 * @author jerry7
 */
@Component
public class WorkflowCompetenceEventListener implements CompetenceEventListener {
  @Autowired(required = false)
  private WorkflowCompetenceRepository workflowCompetenceRepository;

  @Autowired(required = false)
  private DefaultCompetenceRepository defaultCompetenceRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public void onCreated(CompetenceVo competence) {
    // 当进行功能创建时，如果创建的功能是DefaultCompetenceVo，那么这里需要进行扩展信息的处理
    if (!(competence instanceof WorkflowCompetenceVo)) {
      return;
    }
    WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo) competence;
    String competenceCode = workflowCompetenceVo.getCode();

    // 试图进行边界校验后报错，TODO 这段代码需要迁移到对应的service中
    WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
    Validate.isTrue(exsit == null, "添加功能时，发现默认功能中已经关联了对应的功能基本信息业务编号，请检查!!");
    WorkflowCompetenceEntity workflowCompetenceEntity = new WorkflowCompetenceEntity();
    workflowCompetenceEntity.setExtractUri(workflowCompetenceVo.getExtractUri());
    workflowCompetenceEntity.setMethods(workflowCompetenceVo.getMethods());
    workflowCompetenceEntity.setCompetenceCode(competenceCode);
    workflowCompetenceEntity.setRelationBillCode(workflowCompetenceVo.getRelationBillCode());
    if (StringUtils.isBlank(workflowCompetenceVo.getTag())) {
      workflowCompetenceEntity.setTag("");
    } else {
      workflowCompetenceEntity.setTag(workflowCompetenceVo.getTag());
    }
    // 保存
    this.workflowCompetenceRepository.save(workflowCompetenceEntity);
  }

  @Override
  public void onUpdate(CompetenceVo competence) {
    // 当进行功能创建时，如果创建的功能是DefaultCompetenceVo，那么这里需要进行扩展信息的处理
    if (!(competence instanceof WorkflowCompetenceVo)) {
      return;
    }
    WorkflowCompetenceVo workflowCompetenceVo = (WorkflowCompetenceVo) competence;
    String competenceCode = workflowCompetenceVo.getCode();

    // 先从工作流扩展菜单表查询，如果没有查询到实体则去默认菜单表查询，两个表都没有查询到数据时抛出异常
    WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
    if (ObjectUtils.isEmpty(exsit)) {
      DefaultCompetenceEntity defaultEntity = this.defaultCompetenceRepository.findByCompetenceCode(competenceCode);
      Validate.isTrue(defaultEntity != null, "修改功能时，发现默认功能中不存在入参信息，请检查!!");
      //当从默认菜单表查询到数据时，拷贝到exist
      exsit = this.nebulaToolkitService.copyObjectByWhiteList(defaultEntity, WorkflowCompetenceEntity.class, HashSet.class, ArrayList.class);
    }
    exsit.setExtractUri(workflowCompetenceVo.getExtractUri());
    exsit.setMethods(workflowCompetenceVo.getMethods());
    exsit.setRelationBillCode(workflowCompetenceVo.getRelationBillCode());
    exsit.setCompetenceCode(competenceCode);

    if (StringUtils.isBlank(workflowCompetenceVo.getTag())) {
      exsit.setTag("");
    } else {
      exsit.setTag(workflowCompetenceVo.getTag());
    }
    // 保存
    this.workflowCompetenceRepository.saveOrUpdate(exsit);
  }

  @Override
  public void onDeleted(CompetenceVo competence) {
    if (!(competence instanceof WorkflowCompetenceVo)) {
      return;
    }
    // 一旦基本功能信息被删除，则其关联的默认功能信息也将被删除
    String competenceCode = competence.getCode();
    WorkflowCompetenceEntity exsit = this.workflowCompetenceRepository.findByCompetenceCode(competenceCode);
    Validate.notNull(exsit, "删除功能时，发现默认功能中没有关联对应的功能基本信息业务编号，请检查!!");
    // 进行删除
    this.workflowCompetenceRepository.removeById(exsit.getId());
  }
}
