package com.biz.crm.mdm.business.competence.workflow;

import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 工作流扩展菜单功能模型
 *
 * @author jerry7
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class WorkflowCompetenceVo extends CompetenceVo {

  private static final long serialVersionUID = 6197880263591465203L;
  @ApiModelProperty(name = "competenceCode", value = "对应的功能模块的业务编号信息（唯一存在）")
  private String competenceCode;
  /**
   * 权限URL串.
   **/
  @ApiModelProperty(name = "resource", value = "权限URL串")
  private String resource = "";
  /**
   * 涉及的方法描述。例如：POST或者POST|GET|DELETE
   */
  @ApiModelProperty(name = "methods", value = "涉及的方法描述，例如：POST或者POST|GET|DELETE", required = true)
  private String methods = "";
  /**
   * 菜单说明
   */
  @ApiModelProperty("菜单说明")
  private String description;
  /**
   * 这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径
   */
  @ApiModelProperty("这个路径是否是带有匹配符的动态路径；1：动态路径；0：非动态路径")
  private Integer extractUri = 0;
  /**
   * 标签
   **/
  @ApiModelProperty(name = "tag", value = "标签")
  private String tag;
  /**
   * 关联单据编码(扩展字段)
   **/
  @ApiModelProperty(name = "relationBillCode", value = "关联单据编码")
  private String relationBillCode;
}
