package com.biz.crm.mdm.business.customer.channel.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.feign.feign.CustomerChannelVoFeign;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户渠道feign接口熔断类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 13:59
 */
@Component
public class CustomerChannelVoFeignImpl implements FallbackFactory<CustomerChannelVoFeign> {
    @Override
    public CustomerChannelVoFeign create(Throwable throwable) {
        return new CustomerChannelVoFeign() {
            @Override
            public Result<Page<CustomerChannelVo>> findByConditions(Integer page, Integer size, CustomerChannelDto dto) {
                throw new UnsupportedOperationException("根据条件查询客户渠道列表熔断");
            }

            @Override
            public Result<CustomerChannelVo> findById(String id) {
                throw new UnsupportedOperationException("根据ID查询客户渠道熔断");
            }

            @Override
            public Result<List<CustomerChannelVo>> findByIds(List<String> idList) {
                throw new UnsupportedOperationException("根据ID集合查询客户渠道熔断");
            }

            @Override
            public Result<CustomerChannelVo> findByCode(String code) {
                throw new UnsupportedOperationException("根据编码查询客户渠道熔断");
            }

            @Override
            public Result<List<CustomerChannelVo>> findByCodes(List<String> codeList) {
                throw new UnsupportedOperationException("根据编码集合查询客户渠道熔断");
            }

            @Override
            public Result<List<CustomerChannelVo>> findByName(String name) {
                throw new UnsupportedOperationException("根据渠道名称查渠道信息熔断");
            }
        };
    }
}
