package com.biz.crm.mdm.business.customer.channel.feign.service.internal;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.feign.feign.CustomerChannelVoFeign;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;

/**
 * 客户渠道(CustomerChannel)
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 11:51
 */
@Service
public class CustomerChannelVoServiceImpl implements CustomerChannelVoService {

    @Autowired(required = false)
    private CustomerChannelVoFeign customerChannelVoFeign;

    /**
     * 多条件分页查询
     *
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.22 14:15
     */
    @Override
    public Page<CustomerChannelVo> findByConditions(Pageable pageable, CustomerChannelDto dto) {
        Result<Page<CustomerChannelVo>> result =
            customerChannelVoFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据ID查询详情
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.22 0:25
     */
    @Override
    public CustomerChannelVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        Result<CustomerChannelVo> result = customerChannelVoFeign.findById(id);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据ID集合查询详情
     *
     * @param idList ID集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.22 0:26
     */
    @Override
    public List<CustomerChannelVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerChannelVo>> result = customerChannelVoFeign.findByIds(idList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据编码查询详情
     *
     * @param code 编码
     * @return com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.22 0:27
     */
    @Override
    public CustomerChannelVo findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        Result<CustomerChannelVo> result = customerChannelVoFeign.findByCode(code);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据编码集合查询详情
     *
     * @param codeList 编码集合
     * @return java.util.List<com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.22 0:27
     */
    @Override
    public List<CustomerChannelVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<CustomerChannelVo>> result = customerChannelVoFeign.findByCodes(codeList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据所属客户渠道编码查询所属客户渠道区域
     * 
     * @param customerChannelCode
     * @return
     */
    @Override
    public String findByCustomerChannelName(String customerChannelCode) {
        if (StringUtils.isBlank(customerChannelCode)) {
            return null;
        }
        return null;
    }

    /**
     * 根据渠道名称查渠道信息
     *
     * @param name
     * @return
     */
    @Override
    public List<CustomerChannelVo> findByName(String name) {
        if (StringUtils.isBlank(name)){
            return null;
        }
        Result<List<CustomerChannelVo>> result = customerChannelVoFeign.findByName(name);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

}
