package com.biz.crm.mdm.business.customer.channel.local.controller;



import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.service.CustomerChannelService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 客户渠道主表(CustomerChannel)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2022-10-31 17:04:10
 */
@RestController
@RequestMapping("/v1/customerChannel/customerChannel")
@Slf4j
@Api(tags = "客户渠道主表")
public class CustomerChannelController {
  /**
  * 服务对象
  */
  @Autowired
  private CustomerChannelService customerChannelService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CustomerChannelVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "customerChannel", value = "客户渠道主表") CustomerChannelDto dto) {
    try {
      Page<CustomerChannelVo> page =  this.customerChannelService.findByConditions(pageable,dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CustomerChannel> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CustomerChannel customerChannel = this.customerChannelService.findById(id);
      return Result.ok(customerChannel);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param customerChannel 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CustomerChannel> create(@ApiParam(name = "customerChannel", value = "客户渠道主表") @RequestBody CustomerChannel customerChannel) {
    try {
      CustomerChannel result = this.customerChannelService.create(customerChannel);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param customerChannel 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<CustomerChannel> update(@ApiParam(name = "customerChannel", value = "客户渠道主表") @RequestBody CustomerChannel customerChannel) {
    try {
      CustomerChannel result = this.customerChannelService.update(customerChannel);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.customerChannelService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param idList ID集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> idList) {
    try {
      this.customerChannelService.enableBatch(idList);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param idList ID集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> idList) {
    try {
      this.customerChannelService.disableBatch(idList);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
