package com.biz.crm.mdm.business.customer.channel.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户渠道(CustomerChannel)
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 11:48
 */
@RestController
@RequestMapping("/v1/customerChannel/customerChannelVo")
@Slf4j
@Api(tags = "MDM-客户渠道VO")
public class CustomerChannelVoController {

    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @ApiOperation(value = "查询分页列表")
    @GetMapping("findByConditions")
    public Result<Page<CustomerChannelVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "dto", value = "客户渠道") CustomerChannelDto dto) {
        try {
            Page<CustomerChannelVo> page = this.customerChannelVoService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据id详情")
    @GetMapping("findById")
    public Result<CustomerChannelVo> findById(@RequestParam("id") String id) {
        try {
            CustomerChannelVo mdmUnit = this.customerChannelVoService.findById(id);
            return Result.ok(mdmUnit);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据id集合详情")
    @GetMapping(value = {"/findByIds"})
    public Result<List<CustomerChannelVo>> findByIds(@RequestParam("idList") List<String> idList) {
        try {
            List<CustomerChannelVo> list = this.customerChannelVoService.findByIds(idList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据编码查询详情")
    @GetMapping("findByCode")
    public Result<CustomerChannelVo> findByCode(@RequestParam("code") String code) {
        try {
            CustomerChannelVo mdmUnit = this.customerChannelVoService.findByCode(code);
            return Result.ok(mdmUnit);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据编码集合查询详情")
    @GetMapping(value = {"/findByCodes"})
    public Result<List<CustomerChannelVo>> findByCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<CustomerChannelVo> list = this.customerChannelVoService.findByCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    @ApiOperation(value = "根据渠道名称查渠道信息")
    @GetMapping(value = {"/findByName"})
    public Result<List<CustomerChannelVo>> findByName(@RequestParam("name") String name) {
        try {
            List<CustomerChannelVo> list = this.customerChannelVoService.findByName(name);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
