package com.biz.crm.mdm.business.customer.channel.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 客户渠道信息数据视图
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 11:13
 */
@Component
public class CustomerChannelDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_customer_channel_dataview";
    }

    @Override
    public String desc() {
        return "MDM客户渠道信息数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT mcc.* " +
                "FROM mdm_customer_channel mcc " +
                "WHERE mcc.tenant_code =  :tenantCode " +
                " and mcc.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
