package com.biz.crm.mdm.business.customer.channel.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 客户渠道主表(CustomerChannel)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-10-31 17:04:11
 */
public interface CustomerChannelMapper extends BaseMapper<CustomerChannel> {

    /**
     * 分页查询所有数据
     *
     * @param page            分页对象
     * @param customerChannel 查询实体
     * @return 所有数据
     */
    Page<CustomerChannelVo> findByConditions(@Param("page") Page<CustomerChannelVo> page, @Param("dto") CustomerChannelDto customerChannel);


    /**
     * 根据渠道名称查渠道信息
     *
     * @param name
     * @return
     */
    List<CustomerChannelVo> findByName(@Param("name") String name);

    /**
     * 条件查询
     * @param dto
     * @return {@link List}<{@link CustomerChannelVo}>
     */
    List<CustomerChannelVo> findByCustomerChannelDto(@Param("dto") CustomerChannelDto dto);
}

