/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.service.CustomerChannelService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/customerChannel/customerChannel"})
@Api(tags={"\u5ba2\u6237\u6e20\u9053\u4e3b\u8868"})
public class CustomerChannelController {
    private static final Logger log = LoggerFactory.getLogger(CustomerChannelController.class);
    @Autowired
    private CustomerChannelService customerChannelService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CustomerChannelVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="customerChannel", value="\u5ba2\u6237\u6e20\u9053\u4e3b\u8868") CustomerChannelDto dto) {
        try {
            Page<CustomerChannelVo> page = this.customerChannelService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<CustomerChannel> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            CustomerChannel customerChannel = this.customerChannelService.findById(id);
            return Result.ok((Object)((Object)customerChannel));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<CustomerChannel> create(@ApiParam(name="customerChannel", value="\u5ba2\u6237\u6e20\u9053\u4e3b\u8868") @RequestBody CustomerChannel customerChannel) {
        try {
            CustomerChannel result = this.customerChannelService.create(customerChannel);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<CustomerChannel> update(@ApiParam(name="customerChannel", value="\u5ba2\u6237\u6e20\u9053\u4e3b\u8868") @RequestBody CustomerChannel customerChannel) {
        try {
            CustomerChannel result = this.customerChannelService.update(customerChannel);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> idList) {
        try {
            this.customerChannelService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> idList) {
        try {
            this.customerChannelService.enableBatch(idList);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> idList) {
        try {
            this.customerChannelService.disableBatch(idList);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

