/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.mapper.CustomerChannelMapper;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class CustomerChannelRepository
extends ServiceImpl<CustomerChannelMapper, CustomerChannel> {
    @Autowired
    private CustomerChannelMapper customerChannelMapper;

    public Page<CustomerChannelVo> findByConditions(Pageable pageable, CustomerChannelDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerChannelDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.customerChannelMapper.findByConditions((Page<CustomerChannelVo>)page, dto);
    }

    public void disableBatch(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void enableBatch(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void delete(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public CustomerChannel findById(String id) {
        if (!StringUtils.hasText((String)id)) {
            return null;
        }
        return (CustomerChannel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CustomerChannel> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public CustomerChannel findByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return null;
        }
        return (CustomerChannel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomerChannel::getCustomerChannelCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CustomerChannel> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomerChannel::getCustomerChannelCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public CustomerChannel findByIndustryDeliveryWayName(String customerChannelCode) {
        if (StringUtils.isEmpty((Object)customerChannelCode)) {
            return new CustomerChannel();
        }
        return (CustomerChannel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CustomerChannel::getCustomerChannelCode, new Object[]{customerChannelCode})).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<CustomerChannelVo> findByName(String name) {
        return this.customerChannelMapper.findByName(name);
    }

    public List<CustomerChannelVo> findByCodeOrName(List<String> codeOrName) {
        Assert.notEmpty(codeOrName, (String)"\u7f16\u7801\u540d\u79f0\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CustomerChannelDto dto = new CustomerChannelDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCodeOrNameList(codeOrName);
        return ((CustomerChannelMapper)this.baseMapper).findByCustomerChannelDto(dto);
    }
}

