/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.repository.CustomerChannelRepository;
import com.biz.crm.mdm.business.customer.channel.local.service.CustomerChannelService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="customerChannelService")
public class CustomerChannelServiceImpl
implements CustomerChannelService {
    @Autowired
    private CustomerChannelRepository customerChannelRepository;

    @Override
    public Page<CustomerChannelVo> findByConditions(Pageable pageable, CustomerChannelDto dto) {
        return this.customerChannelRepository.findByConditions(pageable, dto);
    }

    @Override
    public CustomerChannel findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerChannelRepository.findById(id);
    }

    @Override
    @Transactional
    public CustomerChannel create(CustomerChannel customerChannel) {
        this.createValidate(customerChannel);
        this.customerChannelRepository.save((Object)customerChannel);
        return customerChannel;
    }

    @Override
    @Transactional
    public CustomerChannel update(CustomerChannel customerChannel) {
        this.updateValidate(customerChannel);
        this.customerChannelRepository.saveOrUpdate((Object)customerChannel);
        return customerChannel;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.customerChannelRepository.delete(idList);
    }

    @Override
    public void enableBatch(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.customerChannelRepository.enableBatch(idList);
    }

    @Override
    public void disableBatch(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.customerChannelRepository.disableBatch(idList);
    }

    @Override
    public CustomerChannel findByCode(String customerChannelCode) {
        if (StringUtils.isNotBlank((CharSequence)customerChannelCode)) {
            return null;
        }
        return this.customerChannelRepository.findByCode(customerChannelCode);
    }

    private void createValidate(CustomerChannel customerChannel) {
        Validate.notNull((Object)((Object)customerChannel), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        customerChannel.setId(null);
        customerChannel.setTenantCode(TenantUtils.getTenantCode());
        customerChannel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        customerChannel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)customerChannel.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerChannel.getCustomerChannelCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerChannel.getCustomerChannelName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerChannel.getCustomerChannelType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String customerChannelCode = customerChannel.getCustomerChannelCode();
        CustomerChannel byCode = this.customerChannelRepository.findByCode(customerChannelCode);
        Validate.isTrue((boolean)Objects.isNull((Object)byCode), (String)"\u7f16\u7801\u91cd\u590d\uff0c\u5305\u542b\u903b\u8f91\u5220\u9664\u7684\u6570\u636e", (Object[])new Object[0]);
    }

    private void updateValidate(CustomerChannel customerChannel) {
        Validate.notNull((Object)((Object)customerChannel), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        customerChannel.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)customerChannel.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerChannel.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerChannel.getCustomerChannelCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerChannel.getCustomerChannelName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerChannel.getCustomerChannelType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u6e20\u9053\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

