/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.repository.CustomerChannelRepository;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CustomerChannelVoServiceImpl
implements CustomerChannelVoService {
    private static final Logger log = LoggerFactory.getLogger(CustomerChannelVoServiceImpl.class);
    @Autowired(required=false)
    private CustomerChannelRepository customerChannelRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<CustomerChannelVo> findByConditions(Pageable pageable, CustomerChannelDto dto) {
        return this.customerChannelRepository.findByConditions(pageable, dto);
    }

    public CustomerChannelVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        CustomerChannel promoters = this.customerChannelRepository.findById(id);
        if (Objects.isNull((Object)promoters)) {
            return null;
        }
        return (CustomerChannelVo)this.nebulaToolkitService.copyObjectByBlankList((Object)promoters, CustomerChannelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerChannelVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<CustomerChannel> promotersList = this.customerChannelRepository.findByIds(idList);
        if (CollectionUtils.isEmpty(promotersList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(promotersList, CustomerChannel.class, CustomerChannelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public CustomerChannelVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        CustomerChannel entity = this.customerChannelRepository.findByCode(code);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        return (CustomerChannelVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CustomerChannelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerChannelVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<CustomerChannel> entityList = this.customerChannelRepository.findByCodes(codeList);
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, CustomerChannel.class, CustomerChannelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public String findByCustomerChannelName(String customerChannelCode) {
        Validate.notEmpty((CharSequence)customerChannelCode, (String)"\u5ba2\u6237\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerChannel customerChannel = this.customerChannelRepository.findByIndustryDeliveryWayName(customerChannelCode);
        if (ObjectUtils.isEmpty((Object)((Object)customerChannel))) {
            return null;
        }
        return customerChannel.getCustomerChannelName();
    }

    public List<CustomerChannelVo> findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.customerChannelRepository.findByName(name);
    }

    public List<CustomerChannelVo> findByCodeOrName(List<String> codeOrName) {
        return this.customerChannelRepository.findByCodeOrName(codeOrName);
    }
}

