package com.biz.crm.mdm.business.customer.channel.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author HanJiaJun
 * @describe: 客户渠道实体
 * @createTime 2022年10月31日 15:20:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_channel")
@Entity
@Table(name = "mdm_customer_channel", indexes = {
    @Index(columnList = "customer_channel_code,tenant_code", unique = true)
    ,@Index(columnList = "tenant_code")})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_channel", comment = "客户渠道主表")
public class CustomerChannel extends TenantFlagOpEntity {

  /**
   * 客户渠道编码
   */
  @Column(name = "customer_channel_code", nullable = false, unique = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
  @ApiModelProperty(value = "客户渠道编码")
  private String customerChannelCode;
  /**
   * 客户渠道名称
   */
  @Column(name = "customer_channel_name", nullable = false,  length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户渠道名称'")
  @ApiModelProperty(value = "客户渠道名称")
  private String customerChannelName;
  /**
   * 渠道分类
   */
  @Column(name = "customer_channel_type", nullable = false,length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道名称'")
  @ApiModelProperty(value = "客户渠道分类")
  private String customerChannelType;
}
