package com.biz.crm.mdm.business.customer.channel.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.mapper.CustomerChannelMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 客户渠道主表(CustomerChannel)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-10-31 17:04:11
 */
@Component
public class CustomerChannelRepository extends ServiceImpl<CustomerChannelMapper, CustomerChannel> {

  @Autowired
  private CustomerChannelMapper customerChannelMapper;

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param customerChannel 实体对象
   * @return
   */
  public Page<CustomerChannel> findByConditions(Pageable pageable, CustomerChannel customerChannel) {
    Page<CustomerChannel> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    customerChannel.setTenantCode(TenantUtils.getTenantCode());    //新增租户编号判断条件
    Page<CustomerChannel> pageList = customerChannelMapper.findByConditions(page, customerChannel);
    return pageList;
  }

  /**
   * 禁用
   *
   * @param idList
   */
  public void disableBatch(List<String> idList) {
    this.lambdaUpdate()
        .set(CustomerChannel::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
        .eq(CustomerChannel::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
        .in(CustomerChannel::getId, idList)
        .update();
  }

  /**
   * 启用
   *
   * @param idList
   */
  public void enableBatch(List<String> idList) {
    this.lambdaUpdate()
        .set(CustomerChannel::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(CustomerChannel::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
        .in(CustomerChannel::getId, idList)
        .update();
  }

  public void delete(List<String> idList) {
    this.lambdaUpdate()
        .set(CustomerChannel::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(CustomerChannel::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
        .in(CustomerChannel::getId, idList)
        .update();
  }

  public CustomerChannel findByCode(String customerChannelCode) {
    return this.lambdaQuery()
        .eq(CustomerChannel::getTenantCode,TenantUtils.getTenantCode())    //新增租户编号判断条件
        .eq(CustomerChannel::getCustomerChannelCode,customerChannelCode)
        .one();
  }
}

