package com.biz.crm.mdm.business.customer.channel.local.service.internal;



import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.channel.local.repository.CustomerChannelRepository;
import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.biz.crm.mdm.business.customer.channel.local.service.CustomerChannelService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 客户渠道主表(CustomerChannel)表服务实现类
 *
 * @author HanJiaJun
 * @since 2022-10-31 17:04:10
 */
@Service("customerChannelService")
public class CustomerChannelServiceImpl implements CustomerChannelService {

  @Autowired
  private CustomerChannelRepository customerChannelRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param customerChannel 实体对象
   * @return
   */
  @Override
  public Page<CustomerChannel> findByConditions(Pageable pageable, CustomerChannel customerChannel) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(customerChannel)) {
      customerChannel = new CustomerChannel();
    }
    return this.customerChannelRepository.findByConditions(pageable, customerChannel);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CustomerChannel findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.customerChannelRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param customerChannel 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CustomerChannel create(CustomerChannel customerChannel) {
    this.createValidate(customerChannel);
    this.customerChannelRepository.save(customerChannel);
    return customerChannel;
  }
  
  /**
   * 修改新据
   * @param customerChannel 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CustomerChannel update(CustomerChannel customerChannel) {
    this.updateValidate(customerChannel);
    this.customerChannelRepository.saveOrUpdate(customerChannel);
    return customerChannel;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.customerChannelRepository.delete(idList);
  }

  @Override
  public void enableBatch(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList),"主键集合不能为空！");
    this.customerChannelRepository.enableBatch(idList);
  }

  @Override
  public void disableBatch(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList),"主键集合不能为空！");
    this.customerChannelRepository.disableBatch(idList);
  }

  @Override
  public CustomerChannel findByCode(String customerChannelCode) {
    if (StringUtils.isNotBlank(customerChannelCode)){
      return  null;
    }
    return this.customerChannelRepository.findByCode(customerChannelCode);

  }

  /**
   * 创建验证
   * @param customerChannel
   */
  private void createValidate(CustomerChannel customerChannel) {
    Validate.notNull(customerChannel, "新增时，对象信息不能为空！");
	  customerChannel.setId(null);
    customerChannel.setTenantCode(TenantUtils.getTenantCode());
    customerChannel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    customerChannel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    Validate.notNull(customerChannel.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notNull(customerChannel.getCustomerChannelCode(), "新增数据时，客户渠道编码不能为空！");
    Validate.notNull(customerChannel.getCustomerChannelName(), "新增数据时，客户渠道名称不能为空！");
    Validate.notNull(customerChannel.getCustomerChannelType(), "新增数据时，客户渠道分类不能为空！");
    String customerChannelCode = customerChannel.getCustomerChannelCode();
    CustomerChannel byCode = this.customerChannelRepository.findByCode(customerChannelCode);
    Validate.isTrue(Objects.isNull(byCode),"编码重复，包含逻辑删除的数据");

  }
  
   /**
   * 修改验证
   * @param customerChannel
   */
  private void updateValidate(CustomerChannel customerChannel) {
    Validate.notNull(customerChannel, "修改时，对象信息不能为空！");
    customerChannel.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(customerChannel.getId(), "修改数据时，ID不能为空！");
    Validate.notBlank(customerChannel.getTenantCode(), "修改数据时，租户编号不能为空！");
    Validate.notBlank(customerChannel.getCustomerChannelCode(), "修改数据时，客户渠道编码不能为空！");
    Validate.notBlank(customerChannel.getCustomerChannelName(), "修改数据时，客户渠道名称不能为空！");
    Validate.notNull(customerChannel.getCustomerChannelType(), "新增数据时，客户渠道分类不能为空！");
      
  }
}

