package com.biz.crm.mdm.business.customer.channel.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 客户渠道Dto
 * @createTime 2022年10月31日 17:20:00
 */
@Data
public class CustomerChannelDto  extends TenantFlagOpVo {

  /**
   * 客户渠道编码
   */
  @ApiModelProperty(value = "客户渠道编码")
  private String customerChannelCode;
  /**
   * 客户渠道名称
   */
  @ApiModelProperty(value = "客户渠道名称")
  private String customerChannelName;
  /**
   * 编码、名称
   */
  @ApiModelProperty(value = "编码、名称")
  private String codeOrName;
  /**
   * 渠道分类
   */
  @ApiModelProperty(value = "客户渠道分类")
  private String customerChannelType;

  @ApiModelProperty(name = "codeOrNameList", notes = "编码/名称")
  private List<String> codeOrNameList;
}
