package com.biz.crm.mdm.business.customer.channel.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.google.common.collect.Lists;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;

/**
 * 客户渠道主表(CustomerChannel)表服务接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.22 11:14
 */
public interface CustomerChannelVoService {


    /**
     * 查询分页列表
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.customer.channel.sdk.vo.PromotersVo>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:52
     */
    Page<CustomerChannelVo> findByConditions(Pageable pageable, CustomerChannelDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    CustomerChannelVo findById(String id);

    /**
     * 按id集合查询详情
     *
     * @param idList
     * @return
     */
    List<CustomerChannelVo> findByIds(List<String> idList);

    /**
     * 按编码查询详情
     *
     * @param code 编码
     * @return
     */
    CustomerChannelVo findByCode(String code);

    /**
     * 按编码集合查询详情
     *
     * @param codeList 编码集合
     * @return
     */
    List<CustomerChannelVo> findByCodes(List<String> codeList);

    /**
     * 根据所属客户渠道编码查询所属客户渠道区域
     * @param customerChannelCode
     * @return
     */
    String findByCustomerChannelName(String customerChannelCode);
    /**
     * 根据渠道名称查渠道信息
     *
     * @param name
     * @return
     */
    List<CustomerChannelVo> findByName(String name);

    /**
     * 根据编码或者名称查询
     * @param codeOrName
     * @return {@link List}<{@link CustomerChannelVo}>
     */
    default List<CustomerChannelVo> findByCodeOrName(List<String> codeOrName){
        return Lists.newArrayList();
    }
}

