package com.biz.crm.mdm.business.terminal.channel.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.channel.feign.feign.internal.MdmTerminalChannelVoFeignImpl;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月20日 11:41
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = MdmTerminalChannelVoFeignImpl.class)
public interface MdmTerminalChannelVoFeign {

    /**
     * 批量查询终端渠道
     *
     * @param codes
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo>>
     * @author huojia
     * @date 2022/12/20 11:43
     **/
    @PostMapping("/v1/terminalChannel/terminalChannel/listByCodes")
    Result<List<MdmTerminalChannelVo>> listByCodes(@RequestBody List<String> codes);

    /**
     * 编码查询名称
     *
     * @param codes 终端渠道查询参数
     * @return Map<String, String>
     */
    @ApiOperation(value = "编码查询名称")
    @PostMapping("/v1/terminalChannel/terminalChannel/findNameByCodes")
    Result<Map<String, String>> findNameByCodes(@RequestBody List<String> codes);
}
