package com.biz.crm.mdm.business.terminal.channel.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.channel.local.dto.TerminalChannelSelectDto;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.service.MdmTerminalChannelService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 终端渠道主表(MdmTerminalChannel)表相关的http接口
 *
 * @author HanJiaJun
 * @since 2022-11-04 14:33:37
 */
@RestController
@RequestMapping("/v1/terminalChannel/terminalChannel")
@Slf4j
@Api(tags = "终端渠道：TerminalChannel：终端渠道")
public class MdmTerminalChannelController {
  /**
  * 服务对象
  */
  @Autowired
  private MdmTerminalChannelService mdmTerminalChannelService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param mdmTerminalChannel 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<MdmTerminalChannel>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
												   @ApiParam(name = "mdmTerminalChannel", value = "终端渠道主表") MdmTerminalChannel mdmTerminalChannel) {
    try {
      Page<MdmTerminalChannel> page =  this.mdmTerminalChannelService.findByConditions(pageable,mdmTerminalChannel);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "终端渠道下拉")
  @PostMapping("findSelectByConditions")
  public Result<List<MdmTerminalChannel>> findSelectByConditions(@ApiParam(name = "TerminalChannelSelectDto", value = "查询参数") @RequestBody TerminalChannelSelectDto dto) {
    try {
      List<MdmTerminalChannel> list = mdmTerminalChannelService.findSelectByConditions(dto);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  
  /**
   * 新增数据
   *
   * @param mdmTerminalChannel 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<MdmTerminalChannel> create(@ApiParam(name = "mdmTerminalChannel", value = "终端渠道主表") @RequestBody MdmTerminalChannel mdmTerminalChannel) {
    try {
      MdmTerminalChannel result = this.mdmTerminalChannelService.create(mdmTerminalChannel);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param mdmTerminalChannel 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<MdmTerminalChannel> update(@ApiParam(name = "mdmTerminalChannel", value = "终端渠道主表") @RequestBody MdmTerminalChannel mdmTerminalChannel) {
    try {
      MdmTerminalChannel result = this.mdmTerminalChannelService.update(mdmTerminalChannel);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.mdmTerminalChannelService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 启用
   * @param idList 主键
   */
  @PatchMapping("enableBatch")
  public Result<?> enableBatch(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.mdmTerminalChannelService.enableBatch(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 禁用
   * @param idList 主键
   */
  @PatchMapping("disableBatch")
  public Result<?> disableBatch(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.mdmTerminalChannelService.disableBatch(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 重置降维编码
   */
  @ApiOperation(value = "重置降维编码")
  @PatchMapping("/updateRuleCode")
  public Result<?> updateRuleCode() {
    try {
      this.mdmTerminalChannelService.updateRuleCode();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
