package com.biz.crm.mdm.business.terminal.channel.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.channel.local.dto.TerminalChannelSelectDto;
import com.biz.crm.mdm.business.terminal.channel.local.service.MdmTerminalChannelService;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月11日 15:53:00
 */
@RestController
@RequestMapping("/v1/terminalChannel/terminalChannel")
@Slf4j
@Api(tags = "终端渠道：TerminalChannelVo：终端渠道")
public class MdmTerminalChannelVoController {


  @Autowired
  private MdmTerminalChannelVoService mdmTerminalChannelVoService;

  @Autowired
  private MdmTerminalChannelService mdmTerminalChannelService;


  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<MdmTerminalChannelVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      MdmTerminalChannelVo vo = this.mdmTerminalChannelVoService.findById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量查询终端渠道
   *
   * @param codes
   * @return 单条数据
   */
  @ApiOperation(value = "批量查询终端渠道")
  @PostMapping("listByCodes")
  public Result<List<MdmTerminalChannelVo>> listByCodes(@RequestBody List<String> codes) {
    try {
      List<MdmTerminalChannelVo> result = this.mdmTerminalChannelVoService.listByCodes(codes);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 终端渠道下拉
   *
   * @param dto 终端渠道查询参数
   */
  @ApiOperation(value = "终端渠道下拉")
  @PostMapping("findTerminalChannelSelectList")
  public Result<List<CommonSelectVo>> findTerminalChannelSelectList(@ApiParam(name = "CommonSelectDto", value = "查询参数") @RequestBody TerminalChannelSelectDto dto) {
    try {
      List<CommonSelectVo> list = mdmTerminalChannelService.findTerminalChannelSelectList(dto);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 编码查询名称
   *
   * @param codes 终端渠道查询参数
   */
  @ApiOperation(value = "编码查询名称")
  @PostMapping("findNameByCodes")
  public Result<Map<String, String>> findNameByCodes(@RequestBody List<String> codes) {
    try {
      Map<String, String> map = mdmTerminalChannelVoService.findNameByCodes(codes);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过名称模糊查询
   *
   * @param name
   * @return
   */
  @ApiOperation(value = "通过名称模糊查询")
  @GetMapping("listByName")
  public Result<List<MdmTerminalChannelVo>> listByName(@RequestParam("name") String name) {
    try {
      List<MdmTerminalChannelVo> list = mdmTerminalChannelVoService.listByName(name);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
