package com.biz.crm.mdm.business.terminal.channel.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.channel.local.dto.TerminalChannelSelectDto;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.sdk.dto.TerminalChannelDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 终端渠道主表(MdmTerminalChannel)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-11-04 14:33:37
 */
public interface MdmTerminalChannelService {

  /**
   * 分页查询数据
   *
   * @param pageable           分页对象
   * @param mdmTerminalChannel 实体对象
   * @return
   */
  Page<MdmTerminalChannel> findByConditions(Pageable pageable, MdmTerminalChannel mdmTerminalChannel);

  /**
   * 下拉选择
   *
   * @param dto
   * @return
   */
  List<MdmTerminalChannel> findSelectByConditions(TerminalChannelSelectDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  MdmTerminalChannel findById(String id);

  /**
   * 新增数据
   *
   * @param mdmTerminalChannel 实体对象
   * @return 新增结果
   */
  MdmTerminalChannel create(MdmTerminalChannel mdmTerminalChannel);

  /**
   * 修改新据
   *
   * @param mdmTerminalChannel 实体对象
   * @return 修改结果
   */
  MdmTerminalChannel update(MdmTerminalChannel mdmTerminalChannel);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 通过编码查找
   * @param terminalChannelCode
   * @return
   */
  MdmTerminalChannel findByCode(String terminalChannelCode);

  /**
   * 通过父级编码查询所有子级
   * @param parentChannelCode
   * @return
   */
  List<MdmTerminalChannel> findChildrenListByParentCode(String parentChannelCode);

  /**
   * 通过id集合查询
   * @param idList
   * @return
   */
  List<MdmTerminalChannel> findByIds(List<String> idList);

  /**
   * 启用
   * @param idList
   */
  void enableBatch(List<String> idList);

  /**
   * 禁用
   * @param idList
   */
  void disableBatch(List<String> idList);

  /**
   * 重置降维编码
   */
  void updateRuleCode();

  /**
   * 按条件查询全部
   * @param dto
   * @return
   */
  List<MdmTerminalChannel> findAll(TerminalChannelDto dto);

  /**
   * 终端渠道下拉
   *
   * @param dto 终端渠道查询参数
   */
  List<CommonSelectVo> findTerminalChannelSelectList(TerminalChannelSelectDto dto);

}

