package com.biz.crm.mdm.business.terminal.channel.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.repository.MdmTerminalChannelRepository;
import com.biz.crm.mdm.business.terminal.channel.local.service.MdmTerminalChannelService;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月11日 15:55:00
 */
@Service
public class MdmTerminalChannelVoServiceImpl implements MdmTerminalChannelVoService {
  @Autowired
  private MdmTerminalChannelService mdmTerminalChannelService;

  @Autowired
  private MdmTerminalChannelRepository mdmTerminalChannelRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public MdmTerminalChannelVo findById(String id) {
    MdmTerminalChannel entity = mdmTerminalChannelService.findById(id);
    if (Objects.isNull(entity)){
      return null;
    }
    //查询上级
    String parentChannelCode = entity.getParentChannelCode();
    MdmTerminalChannel parent = mdmTerminalChannelService.findByCode(parentChannelCode);
    MdmTerminalChannelVo mdmTerminalChannelVo = nebulaToolkitService.copyObjectByWhiteList(entity, MdmTerminalChannelVo.class, HashSet.class, ArrayList.class);
    if (Objects.isNull(entity)){
      return mdmTerminalChannelVo;
    }
    mdmTerminalChannelVo.setParentChannelName(parent.getTerminalChannelName());
    return mdmTerminalChannelVo;
  }

  @Override
  public List<MdmTerminalChannelVo> listByCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return Lists.newArrayList();
    }
    List<MdmTerminalChannel> mdmTerminalChannels = this.mdmTerminalChannelRepository.listByCodes(codes);
    if (CollectionUtils.isEmpty(mdmTerminalChannels)) {
      return Lists.newArrayList();
    }
    return (List<MdmTerminalChannelVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
            mdmTerminalChannels, MdmTerminalChannel.class, MdmTerminalChannelVo.class, LinkedHashSet.class, ArrayList.class
    );
  }

  /**
   * 编码查询名称
   * @param codes
   * @return {@link Map}<{@link String}, {@link String}>
   */
  @Override
  public Map<String, String> findNameByCodes(List<String> codes) {
    return this.mdmTerminalChannelRepository.findNameByCodes(codes);
  }

  @Override
  public List<MdmTerminalChannelVo> listByName(String name) {
    List<MdmTerminalChannel> list = this.mdmTerminalChannelRepository
            .lambdaQuery()
            .eq(MdmTerminalChannel::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .like(MdmTerminalChannel::getTerminalChannelName, name)
            .list();
    if(CollectionUtils.isEmpty(list)){
      return new ArrayList<>();
    }
    return (List<MdmTerminalChannelVo>) this.nebulaToolkitService
            .copyCollectionByWhiteList(list, MdmTerminalChannel.class, MdmTerminalChannelVo.class, LinkedHashSet.class, ArrayList.class);
  }
}
