/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.channel.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.terminal.channel.local.dto.TerminalChannelSelectDto;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.mapper.MdmTerminalChannelMapper;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class MdmTerminalChannelRepository
extends ServiceImpl<MdmTerminalChannelMapper, MdmTerminalChannel> {
    @Autowired
    private MdmTerminalChannelMapper mdmTerminalChannelMapper;

    public Page<MdmTerminalChannel> findByConditions(Pageable pageable, MdmTerminalChannel mdmTerminalChannel) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        mdmTerminalChannel.setTenantCode(TenantUtils.getTenantCode());
        Page<MdmTerminalChannel> pageList = this.mdmTerminalChannelMapper.findByConditions((Page<MdmTerminalChannel>)page, mdmTerminalChannel);
        return pageList;
    }

    public List<MdmTerminalChannel> findSelectByConditions(TerminalChannelSelectDto dto) {
        return this.mdmTerminalChannelMapper.findSelectByConditions(dto, 50);
    }

    public MdmTerminalChannel findByCode(String terminalChannelCode) {
        return (MdmTerminalChannel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalChannel::getTerminalChannelCode, (Object)terminalChannelCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<MdmTerminalChannel> findChildrenListByParentCode(String parentChannelCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalChannel::getParentChannelCode, (Object)parentChannelCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateRuleCodeAndLevelNumByChannelCode(String terminalChannelCode, String ruleCodeByParentCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalChannel::getTerminalChannelCode, (Object)terminalChannelCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCodeByParentCode)).set(TenantFlagTreeOpEntity::getLevelNum, (Object)levelNum)).update();
    }

    public void updateDelFlagByids(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<MdmTerminalChannel> findByIds(List<String> idList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<MdmTerminalChannel> findChildrenListByParentCodes(Set<String> parentCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalChannel::getParentChannelCode, parentCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MdmTerminalChannel> findbyRuleCodesAndEnableStatus(Set<String> parentRuleCode, String enableCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TenantFlagTreeOpEntity::getRuleCode, parentRuleCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)enableCode)).list();
    }

    public void updateEnableStatusByIds(List<String> idList, String enableCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getEnableStatus, (Object)enableCode)).update();
    }

    public List<MdmTerminalChannel> findCurAndChildrenByRuleCodes(List<String> ruleCodes, String enableCode) {
        return this.mdmTerminalChannelMapper.findCurAndChildrenByRuleCodes(ruleCodes, enableCode, TenantUtils.getTenantCode());
    }

    public List<MdmTerminalChannel> findByParentCodeIsNull(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmTerminalChannel::getParentChannelCode)).or()).eq(MdmTerminalChannel::getParentChannelCode, (Object)"")).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<String> getIdByParentCodeNull(String tenantCode) {
        return this.mdmTerminalChannelMapper.getIdByParentCodeNull(tenantCode);
    }

    public void updateParentCodeNullById(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(MdmTerminalChannel::getParentChannelCode, null)).update();
    }

    public List<MdmTerminalChannel> findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(String enableStatus, String name, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(MdmTerminalChannel::getTerminalChannelName, (Object)name)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).select(new SFunction[]{MdmTerminalChannel::getTerminalChannelCode, TenantFlagTreeOpEntity::getRuleCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<LazyTreeVo> findOrgLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((MdmTerminalChannelMapper)this.baseMapper).findOrgLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public MdmTerminalChannel findByIdAndTenantCode(String id, String tenantCode) {
        return (MdmTerminalChannel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void updateBatchByIdAndTenantCode(List<MdmTerminalChannel> curAndChildrenByRuleCodes, String tenantCode) {
        curAndChildrenByRuleCodes.stream().forEach(mdmTerminalChannel -> {
            LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
            lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
            lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{mdmTerminalChannel.getId()});
            ((MdmTerminalChannelMapper)this.baseMapper).update(mdmTerminalChannel, (Wrapper)lambdaUpdateWrapper);
        });
    }

    public List<CommonSelectVo> findTerminalChannelSelectList(TerminalChannelSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return this.mdmTerminalChannelMapper.findTerminalChannelSelectList(dto, 50);
    }

    public List<MdmTerminalChannel> listByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalChannel::getTerminalChannelCode, codes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Map<String, String> findNameByCodes(List<String> codes) {
        Assert.notEmpty(codes, (String)"\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String tenantCode = TenantUtils.getTenantCode();
        HashMap resultMap = Maps.newHashMap();
        List<MdmTerminalChannel> mdmTerminalChannels = this.mdmTerminalChannelMapper.findNameByCodes(codes, tenantCode);
        if (CollectionUtils.isEmpty(mdmTerminalChannels)) {
            return resultMap;
        }
        mdmTerminalChannels.forEach(o -> resultMap.put(o.getTerminalChannelCode(), o.getTerminalChannelName()));
        return resultMap;
    }
}

