/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.channel.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.terminal.channel.local.dto.TerminalChannelSelectDto;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.repository.MdmTerminalChannelRepository;
import com.biz.crm.mdm.business.terminal.channel.local.service.MdmTerminalChannelService;
import com.biz.crm.mdm.business.terminal.channel.sdk.dto.TerminalChannelDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mdmTerminalChannelService")
public class MdmTerminalChannelServiceImpl
implements MdmTerminalChannelService {
    @Autowired
    private MdmTerminalChannelRepository mdmTerminalChannelRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<MdmTerminalChannel> findByConditions(Pageable pageable, MdmTerminalChannel mdmTerminalChannel) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)mdmTerminalChannel)) {
            mdmTerminalChannel = new MdmTerminalChannel();
        }
        return this.mdmTerminalChannelRepository.findByConditions(pageable, mdmTerminalChannel);
    }

    @Override
    public List<MdmTerminalChannel> findSelectByConditions(TerminalChannelSelectDto dto) {
        return this.mdmTerminalChannelRepository.findSelectByConditions(dto);
    }

    @Override
    public MdmTerminalChannel findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.mdmTerminalChannelRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public MdmTerminalChannel create(MdmTerminalChannel mdmTerminalChannel) {
        this.createValidate(mdmTerminalChannel);
        MdmTerminalChannel form = this.createForm(mdmTerminalChannel);
        form.setTenantCode(TenantUtils.getTenantCode());
        this.mdmTerminalChannelRepository.save((Object)form);
        return mdmTerminalChannel;
    }

    private MdmTerminalChannel createForm(MdmTerminalChannel entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTerminalChannelCode())) {
            String terminalChannelCode = (String)this.generateCodeService.generateCode("TC", 1).get(0);
            entity.setTerminalChannelCode(terminalChannelCode);
        }
        MdmTerminalChannel exits = this.findByCode(entity.getTerminalChannelCode());
        Validate.isTrue((boolean)Objects.isNull((Object)exits), (String)"\u7f16\u7801\u91cd\u590d\uff0c\u5305\u62ec\u5df2\u903b\u8f91\u5220\u9664\u7684\u6570\u636e", (Object[])new Object[0]);
        int levelNum = 1;
        if (StringUtils.isNotBlank((CharSequence)entity.getParentChannelCode())) {
            MdmTerminalChannel parent = this.findByCode(entity.getParentChannelCode());
            Validate.notNull((Object)((Object)parent), (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setParentChannelCode(Optional.ofNullable(entity.getParentChannelCode()).orElse(""));
        String parentChannelCode = entity.getParentChannelCode();
        String ruleCode = this.getRuleCodeByParentCode(parentChannelCode);
        entity.setRuleCode(ruleCode);
        entity.setLevelNum(levelNum);
        return entity;
    }

    private String getRuleCodeByParentCode(String parentChannelCode) {
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentChannelCode)) {
            MdmTerminalChannel parent = this.findByCode(parentChannelCode);
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u6e20\u9053\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<MdmTerminalChannel> childrenListByParentCode = this.findChildrenListByParentCode(parentChannelCode);
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, MdmTerminalChannel.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
        return treeRuleCodeStrategy.generate(4, parentRuleCode, (List)childrenDto);
    }

    @Override
    @Transactional
    public MdmTerminalChannel update(MdmTerminalChannel mdmTerminalChannel) {
        this.updateValidate(mdmTerminalChannel);
        this.updateForm(mdmTerminalChannel);
        this.mdmTerminalChannelRepository.saveOrUpdate((Object)mdmTerminalChannel);
        return mdmTerminalChannel;
    }

    private void updateForm(MdmTerminalChannel mdmTerminalChannel) {
        String currentId = mdmTerminalChannel.getId();
        MdmTerminalChannel current = this.mdmTerminalChannelRepository.findByIdAndTenantCode(currentId, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)current), (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4fee\u6539\u5bf9\u8c61", (Object[])new Object[0]);
        int levelNum = 1;
        Validate.isTrue((boolean)mdmTerminalChannel.getTerminalChannelCode().equals(current.getTerminalChannelCode()), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        String oldRuleCode = current.getRuleCode();
        boolean parentChange = StringUtils.isNotBlank((CharSequence)mdmTerminalChannel.getParentChannelCode()) || StringUtils.isNotBlank((CharSequence)current.getParentChannelCode()) && !Objects.equals(mdmTerminalChannel.getParentChannelCode(), current.getParentChannelCode());
        MdmTerminalChannel parent = null;
        if (StringUtils.isNotBlank((CharSequence)mdmTerminalChannel.getParentChannelCode()) && parentChange) {
            Validate.isTrue((!mdmTerminalChannel.getParentChannelCode().equals(current.getTerminalChannelCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u6e20\u9053\u4e0d\u80fd\u4e3a\u5f53\u524d\u6e20\u9053", (Object[])new Object[0]);
            parent = this.mdmTerminalChannelRepository.findByCode(mdmTerminalChannel.getParentChannelCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u6e20\u9053\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)parent.getRuleCode(), (String)"\u4e0a\u7ea7\u6e20\u9053\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801\u8fdb\u884c\u4fee\u6b63", (Object[])new Object[0]);
            Validate.isTrue((!parent.getRuleCode().startsWith(oldRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u6e20\u9053\u4e0d\u80fd\u662f\u5f53\u524d\u7684\u4e0b\u7ea7\u6e20\u9053", (Object[])new Object[0]);
            levelNum = parent.getLevelNum() + 1;
        }
        mdmTerminalChannel.setTenantCode(TenantUtils.getTenantCode());
        this.mdmTerminalChannelRepository.saveOrUpdate((Object)mdmTerminalChannel);
        if (parentChange) {
            String ruleCodeByParentCode = this.getRuleCodeByParentCode(mdmTerminalChannel.getParentChannelCode());
            this.updateRuleCodeAllChildren(mdmTerminalChannel.getTerminalChannelCode(), ruleCodeByParentCode, levelNum);
        }
    }

    private void updateRuleCodeAllChildren(String terminalChannelCode, String ruleCodeByParentCode, int levelNum) {
        this.mdmTerminalChannelRepository.updateRuleCodeAndLevelNumByChannelCode(terminalChannelCode, ruleCodeByParentCode, levelNum);
        List<MdmTerminalChannel> childrenList = this.mdmTerminalChannelRepository.findChildrenListByParentCode(terminalChannelCode);
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        for (int i = 0; i < childrenList.size(); ++i) {
            MdmTerminalChannel children = childrenList.get(i);
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u4e3a\u7f16\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy strategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)strategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u4e3a\u7f16\u7801\u7b56\u7565", (Object[])new Object[0]);
            String ruleCode = strategy.generateByNum(4, i + 1);
            ruleCode = ruleCodeByParentCode + ruleCode;
            this.updateRuleCodeAllChildren(children.getTerminalChannelCode(), ruleCode, levelNum + 1);
        }
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmTerminalChannel> list = this.findByIds(idList);
        Validate.isTrue((list.size() == idList.size() ? 1 : 0) != 0, (String)"\u5220\u9664\u4e2a\u6570\u4e0e\u5b9e\u9645\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        Map<String, MdmTerminalChannel> parent = list.stream().collect(Collectors.toMap(MdmTerminalChannel::getTerminalChannelCode, t -> t));
        List<MdmTerminalChannel> parentList = this.mdmTerminalChannelRepository.findChildrenListByParentCodes(parent.keySet());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(parentList), (String)"\u5f53\u524dID\u96c6\u5408\u5b58\u5728\u7ed1\u5b9a\u4e86\u4e0b\u7ea7\u6e20\u9053\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.mdmTerminalChannelRepository.updateDelFlagByids(idList);
    }

    @Override
    public MdmTerminalChannel findByCode(String terminalChannelCode) {
        if (StringUtils.isBlank((CharSequence)terminalChannelCode)) {
            return null;
        }
        return this.mdmTerminalChannelRepository.findByCode(terminalChannelCode);
    }

    @Override
    public List<MdmTerminalChannel> findChildrenListByParentCode(String parentChannelCode) {
        if (StringUtils.isBlank((CharSequence)parentChannelCode)) {
            return new ArrayList<MdmTerminalChannel>(0);
        }
        return this.mdmTerminalChannelRepository.findChildrenListByParentCode(parentChannelCode);
    }

    @Override
    public List<MdmTerminalChannel> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return new ArrayList<MdmTerminalChannel>(0);
        }
        return this.mdmTerminalChannelRepository.findByIds(idList);
    }

    @Override
    public void enableBatch(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u542f\u7528\u65f6\uff0cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmTerminalChannel> list = this.mdmTerminalChannelRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(list) && list.size() == idList.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List ruleCodes = list.stream().map(TenantFlagTreeOpEntity::getRuleCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u4e3a\u7f16\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
        TreeRuleCodeStrategy strategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Validate.notNull((Object)strategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u4e3a\u7f16\u7801\u7b56\u7565", (Object[])new Object[0]);
        Set parentRuleCode = strategy.findParentRuleCodeByRuleCodesExcludeAnySelf(4, ruleCodes);
        if (!CollectionUtils.isEmpty((Collection)parentRuleCode)) {
            List<MdmTerminalChannel> parenList = this.mdmTerminalChannelRepository.findbyRuleCodesAndEnableStatus(parentRuleCode, EnableStatusEnum.DISABLE.getCode());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(parenList), (String)"\u5f53\u524d\u542f\u7528\u7684\u6e20\u9053\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u6e20\u9053", (Object[])new Object[0]);
        }
        this.mdmTerminalChannelRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE.getCode());
    }

    @Override
    public void disableBatch(List<String> idList) {
        Validate.notEmpty(idList, (String)"\u7981\u7528\u65f6\uff0cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MdmTerminalChannel> list = this.mdmTerminalChannelRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(idList) && list.size() == idList.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        List<String> ruleCodes = list.stream().map(TenantFlagTreeOpEntity::getRuleCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<MdmTerminalChannel> curAndChildrenByRuleCodes = this.mdmTerminalChannelRepository.findCurAndChildrenByRuleCodes(ruleCodes, EnableStatusEnum.ENABLE.getCode());
        Validate.notEmpty(curAndChildrenByRuleCodes, (String)"\u83b7\u53d6\u5f53\u524d\u53ca\u4e0b\u7ea7\u6e20\u9053\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (MdmTerminalChannel curAndChildrenByRuleCode : curAndChildrenByRuleCodes) {
            curAndChildrenByRuleCode.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        }
        this.mdmTerminalChannelRepository.updateBatchByIdAndTenantCode(curAndChildrenByRuleCodes, TenantUtils.getTenantCode());
    }

    @Override
    public void updateRuleCode() {
        List<String> ids = this.mdmTerminalChannelRepository.getIdByParentCodeNull(TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(ids)) {
            this.mdmTerminalChannelRepository.updateParentCodeNullById(ids);
        }
        List<MdmTerminalChannel> parent = this.mdmTerminalChannelRepository.findByParentCodeIsNull(TenantUtils.getTenantCode());
        for (int i = 0; i < parent.size(); ++i) {
            Validate.notNull((Object)this.treeRuleCodeStrategyHolder, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565\u63a7\u5236\u5668", (Object[])new Object[0]);
            TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
            Validate.notNull((Object)treeRuleCodeStrategy, (String)"\u7cfb\u7edf\u672a\u914d\u7f6e\u964d\u7ef4\u7801\u7b56\u7565", (Object[])new Object[0]);
            this.updateRuleCodeAllChildren(parent.get(i).getTerminalChannelCode(), treeRuleCodeStrategy.generateByNum(4, i + 1), 1);
        }
    }

    @Override
    public List<MdmTerminalChannel> findAll(TerminalChannelDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TerminalChannelDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return null;
    }

    private void createValidate(MdmTerminalChannel mdmTerminalChannel) {
        Validate.notNull((Object)((Object)mdmTerminalChannel), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        mdmTerminalChannel.setId(null);
        mdmTerminalChannel.setTenantCode(TenantUtils.getTenantCode());
        mdmTerminalChannel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        mdmTerminalChannel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Validate.notNull((Object)mdmTerminalChannel.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)mdmTerminalChannel.getTerminalChannelCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)mdmTerminalChannel.getTerminalChannelName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(MdmTerminalChannel mdmTerminalChannel) {
        Validate.notNull((Object)((Object)mdmTerminalChannel), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        mdmTerminalChannel.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)mdmTerminalChannel.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmTerminalChannel.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmTerminalChannel.getTerminalChannelCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmTerminalChannel.getTerminalChannelName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public List<CommonSelectVo> findTerminalChannelSelectList(TerminalChannelSelectDto dto) {
        return this.mdmTerminalChannelRepository.findTerminalChannelSelectList(dto);
    }
}

