package com.biz.crm.mdm.business.terminal.channel.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月11日 15:53:00
 */
@RestController
@RequestMapping("/v1/terminalChannel/terminalChannel")
@Slf4j
@Api(tags = "终端渠道：TerminalChannelVo：终端渠道")
public class MdmTerminalChannelVoController {


  @Autowired
  private MdmTerminalChannelVoService mdmTerminalChannelVoService;


  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<MdmTerminalChannelVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      MdmTerminalChannelVo vo = this.mdmTerminalChannelVoService.findById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
