package com.biz.crm.mdm.business.terminal.channel.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.TerminalChannelLazyTreeVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 终端渠道主表(MdmTerminalChannel)表mybatis访问层
 *
 * @author HanJiaJun
 * @since 2022-11-04 14:33:37
 */
public interface MdmTerminalChannelMapper extends BaseMapper<MdmTerminalChannel> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param mdmTerminalChannel 查询实体
   * @return 所有数据
  */
  public Page<MdmTerminalChannel> findByConditions(@Param("page") Page<MdmTerminalChannel> page, @Param("mdmTerminalChannel") MdmTerminalChannel mdmTerminalChannel);

  /**
   * 查询当前及下级渠道
   * @param ruleCodes
   * @param enableCode
   * @param tenantCode
   * @return
   */
  List<MdmTerminalChannel> findCurAndChildrenByRuleCodes(@Param("ruleCodes")List<String> ruleCodes,@Param("enableCode") String enableCode,@Param("tenantCode") String tenantCode);

  /**
   * 找到 父级编码不为空但找不到对应的上级的数据 的ID
   * @param tenantCode
   * @return
   */
  List<String> getIdByParentCodeNull(@Param("tenantCode")String tenantCode);

  /**
   * 查询懒加载数据
   *
   * @param enableStatus 启用状态
   * @param topOnly 传true只查第一层
   * @param parentCode 只查询该编码下一级
   * @param codeList 只查询这些编码
   * @param ruleCodeList 只查询这些降维编码
   * @param excludeRuleCode 排除这个降维编码的下级
   * @param tenantCode
   * @return
   */
  List<LazyTreeVo> findOrgLazyTreeList(@Param("enableStatus") String enableStatus,
                                       @Param("topOnly") Boolean topOnly,
                                       @Param("parentCode") String parentCode,
                                       @Param("codeList") List<String> codeList,
                                       @Param("ruleCodeList") List<String> ruleCodeList,
                                       @Param("excludeRuleCode") String excludeRuleCode,
                                       @Param("tenantCode") String tenantCode,
                                       @Param("delFlag") DelFlagStatusEnum delFlag);
}

