package com.biz.crm.mdm.business.terminal.channel.local.service.internal;

import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.service.MdmTerminalChannelService;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月11日 15:55:00
 */
@Service
public class MdmTerminalChannelVoServiceImpl implements MdmTerminalChannelVoService {

  @Autowired
  private MdmTerminalChannelService mdmTerminalChannelService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public MdmTerminalChannelVo findById(String id) {
    MdmTerminalChannel entity = mdmTerminalChannelService.findById(id);
    if (Objects.isNull(entity)){
      return null;
    }
    //查询上级
    String parentChannelCode = entity.getParentChannelCode();
    MdmTerminalChannel parent = mdmTerminalChannelService.findByCode(parentChannelCode);
    MdmTerminalChannelVo mdmTerminalChannelVo = nebulaToolkitService.copyObjectByWhiteList(entity, MdmTerminalChannelVo.class, HashSet.class, ArrayList.class);
    if (Objects.isNull(entity)){
      return mdmTerminalChannelVo;
    }
    mdmTerminalChannelVo.setParentChannelName(parent.getTerminalChannelName());
    return mdmTerminalChannelVo;
  }
}
