/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.channel.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.terminal.channel.local.entity.MdmTerminalChannel;
import com.biz.crm.mdm.business.terminal.channel.local.repository.MdmTerminalChannelRepository;
import com.biz.crm.mdm.business.terminal.channel.sdk.dto.TerminalChannelDto;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelLazyTreeVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MdmTerminalChannelLazyTreeVoServiceImpl
implements MdmTerminalChannelLazyTreeVoService {
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired
    private MdmTerminalChannelRepository mdmTerminalChannelRepository;

    public List<LazyTreeVo> findByTreeDto(TerminalChannelDto dto) {
        ArrayList<LazyTreeVo> tree = new ArrayList<LazyTreeVo>();
        if (!StringUtils.isEmpty((CharSequence)dto.getParentCode())) {
            List<LazyTreeVo> lazyTreeVos = this.mdmTerminalChannelRepository.findOrgLazyTreeList(dto.getEnableStatus(), null, dto.getParentCode(), null, null, null, TenantUtils.getTenantCode());
            tree.addAll(lazyTreeVos);
        } else if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
            List<MdmTerminalChannel> likeList = this.mdmTerminalChannelRepository.findOrgCodeAndRuleCodeByEnableStatusOptAndOrgNameLike(dto.getEnableStatus(), dto.getName(), TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy strategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = strategy.findParentRuleCodeByRuleCodes(4, likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                tree.addAll(this.mdmTerminalChannelRepository.findOrgLazyTreeList(dto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), null, TenantUtils.getTenantCode()));
            }
        } else {
            tree.addAll(this.mdmTerminalChannelRepository.findOrgLazyTreeList(dto.getEnableStatus(), true, null, null, null, null, TenantUtils.getTenantCode()));
        }
        if (!CollectionUtils.isEmpty(tree)) {
            tree.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
            return TreeUtil.generateLazyTreeByParentCode(tree);
        }
        return new ArrayList<LazyTreeVo>(0);
    }
}

