package com.biz.crm.mdm.business.terminal.channel.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelLazyTreeVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.dto.TerminalChannelDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月09日 11:06:00
 */
@RestController
@RequestMapping("/v1/terminalChannel/lazyTree")
@Slf4j
@Api(tags = "终端渠道：TerminalChannelTreeVo：终端渠道树形Vo")
public class MdmTerminalChannelLazyTreeVoController {

  @Autowired
  private MdmTerminalChannelLazyTreeVoService mdmTerminalChannelTreeVoService;


  @ApiOperation("根据条件查询渠道树结构,懒加载")
  @GetMapping("/findAllStruTree")
  public Result<List<LazyTreeVo>> findByTreeDto(TerminalChannelDto dto) {

    try {
      List<LazyTreeVo> byTreeDto = this.mdmTerminalChannelTreeVoService.findByTreeDto(dto);
      return Result.ok(byTreeDto);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
