package com.biz.crm.mdm.business.terminal.channel.sdk.service;

import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年11月11日 15:55:00
 */
public interface MdmTerminalChannelVoService {

  /**
   * 通过ID查询
   *
   * @param id
   * @return
   */
  MdmTerminalChannelVo findById(String id);

  /**
   * 批量查询终端渠道
   *
   * @param codes
   * @return java.util.List<com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo>
   * @author huojia
   * @date 2022/12/20 11:20
   **/
  List<MdmTerminalChannelVo> listByCodes(List<String> codes);

  /**
   * 编码查询名称
   *
   * @param codes
   * @return {@link Map}<{@link String}, {@link String}>
   */
  default Map<String, String> findNameByCodes(List<String> codes) {
    return Maps.newHashMap();
  }

  /**
   * 通过名称模糊查询
   *
   * @param name
   * @return
   */
  default List<MdmTerminalChannelVo> listByName(String name) {
    return new ArrayList<>();
  }
}
