package com.biz.crm.mdm.business.terminal.channel.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * @author HanJiaJun
 * @describe: 终端渠道懒加载入参DTo
 * @createTime 2022年11月09日 11:11:00
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端渠道懒加载树入参DTo")
public class TerminalChannelDto extends TenantFlagOpDto {
  @ApiModelProperty("id")
  private String id;

  @ApiModelProperty("租户")
  private String tenantCode;

  @ApiModelProperty("本节点code")
  private String code;

  @ApiModelProperty("名称")
  private String name;

  @ApiModelProperty("排除这个编码及全部下级")
  private String excludeCodeAndChildren;

  @ApiModelProperty("只查询这个编码及全部下级")
  private String includeCodeAndChildren;

  @ApiModelProperty("启用状态 传009只查启用，不传查询全部")
  private String enableStatus;

  @ApiModelProperty("默认值009")
  private String delFlag;

  @ApiModelProperty("父节点code")
  private String parentCode;

  @ApiModelProperty("规则code查询用")
  private String ruleCode;

  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;
}
