package com.biz.crm.mdm.business.terminal.channel.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 终端渠道树形懒加载返回Vo
 * @createTime 2022年11月09日 11:05:00
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端渠道树形懒加载返回Vo")
public class TerminalChannelLazyTreeVo extends TenantFlagOpVo {

  /**
   * 终端渠道编码
   */
  @ApiModelProperty(value = "终端渠道编码")
  private String terminalChannelCode;
  /**
   * 终端渠道名称
   */
  @ApiModelProperty(value = "终端渠道名称")
  private String terminalChannelName;
  /**
   * 上级渠道编码
   */
  @ApiModelProperty(value = "上级渠道编码")
  private String parentChannelCode;

  /**
   * 规则code查询用
   */
  @ApiModelProperty("规则code")
  private String ruleCode;

  /**
   * 层级等级查询用
   */
  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;

  @ApiModelProperty("是否有下级")
  private Boolean hasChild;

  @ApiModelProperty("是否有下级，1有 0无")
  private Integer hasChildFlag;

  /**
   * 子节点
   */
  @ApiModelProperty("子节点")
  private List<TerminalChannelLazyTreeVo> children;
}
