package com.biz.crm.member.admin.web;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StopWatch;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

/**
 * @author zouhs
 */
@SpringBootApplication(
    scanBasePackages = {"com.biz.crm.member.*", "com.bizunited.nebula.*", "com.biz.crm.common.*"})
@MapperScan(value = {"com.biz.crm.**.mapper*", "com.bizunited.nebula.**.mapper*"})
@EnableTransactionManagement
@EnableSwagger2WebMvc
@Slf4j
@EnableDiscoveryClient
@EnableElasticsearchRepositories(basePackages = "com.biz.crm.common.log.local.repository")
@EnableFeignClients(basePackages = "com.biz.crm.*")
public class ApplicationBootstrap {

  public static void main(String[] args) {
    StopWatch sw = new StopWatch();
    System.setProperty("es.set.netty.runtime.available.processors", "false");
    System.setProperty("nacos.logging.default.config.enabled", "false");
//    -Dnacos.logging.default.config.enabled=false
    sw.start("Spring 容器加载");
    ConfigurableApplicationContext application =
        new SpringApplicationBuilder(ApplicationBootstrap.class).bannerMode(Banner.Mode.OFF)
            .web(WebApplicationType.SERVLET).run(args);
    sw.stop();
    System.err.println("##################################################");
    System.err.println(sw.prettyPrint());

    Environment env = application.getEnvironment();
    String port = env.getProperty("server.port");
    String path = env.getProperty("server.servlet.context-path");
    log.info("\n----------------------------------------------------------\n\t" //
        + "Application crm-member is running! Access URLs:\n\t" //
        + "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" //
        + "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" //
        + "----------------------------------------------------------");
  }
}
