package com.biz.crm.member.admin.web.controller;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaSubscribeService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.member.admin.web.utils.CrmLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序相关接口
 */
@RestController
@RequestMapping("/v1/mini/app")
@Api(tags = "小程序微信相关接口: wx: 小程序微信相关接口")
public class MiniAppController {

    @Autowired(required = false)
    private WxMaService wxMaService;

    @Autowired(required = false)
    private WxMaSubscribeService wxMaSubscribeService;

    /**
     * 获取登录后的session信息
     *
     * @return
     */
    @ApiOperation(value = "获取登录后的session信息")
    @GetMapping("/findSessionByJsCode")
    @CrmLog
    public Result<WxMaJscode2SessionResult> findSessionByJsCode(
            @RequestParam("jsCode") String jsCode) {
        try {
            final WxMaJscode2SessionResult sessionInfo =
                    this.wxMaService.getUserService().getSessionInfo(jsCode);
            return Result.ok(sessionInfo);
        } catch (Exception e) {
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取登录后的session信息
     *
     * @return
     */
    @ApiOperation(value = "获取登录后的电话信息")
    @GetMapping("/findPhoneByPhoneCode")
    @CrmLog
    public Result<WxMaPhoneNumberInfo> findPhoneByJsCode(@RequestParam("phoneCode") String phoneCode) {
        try {
            WxMaPhoneNumberInfo newPhoneNoInfo = this.wxMaService.getUserService().getNewPhoneNoInfo(phoneCode);
            return Result.ok(newPhoneNoInfo);
        } catch (Exception e) {
            return Result.error(e.getMessage());
        }
    }


    /**
     * 解密用户敏感数据
     *
     * @return
     */
    @ApiOperation(value = "解密用户敏感数据")
    @GetMapping("/findWxMaUserInfo")
    @CrmLog
    public Result<WxMaUserInfo> findWxMaUserInfo(
            @RequestParam("sessionKey") String sessionKey,
            @RequestParam("encryptedData") String encryptedData,
            @RequestParam("ivStr") String ivStr) {
        final WxMaUserInfo userInfo =
                this.wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, ivStr);
        return Result.ok(userInfo);
    }

    /**
     * 解密用户手机号信息
     *
     * @return
     */
    @ApiOperation(value = "解密用户手机号信息")
    @GetMapping("/findPhoneInfo")
    @CrmLog
    public Result<WxMaPhoneNumberInfo> findPhoneInfo(
            @RequestParam("sessionKey") String sessionKey,
            @RequestParam("encryptedData") String encryptedData,
            @RequestParam("ivStr") String ivStr) {
        final WxMaPhoneNumberInfo phoneNoInfo =
                this.wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, ivStr);
        return Result.ok(phoneNoInfo);
    }

//    /**
//     * 测试发送订阅消息
//     *
//     * @return
//     */
//    @ApiOperation(value = "测试发送订阅消息")
//    @GetMapping("/sendSubscribeMsg")
//    @CrmLog
//    public Result sendSubscribeMsg() {
////
////        活动主题
////        {{thing1.DATA}}
////
////        奖品名称
////        {{thing10.DATA}}
////
////        到账金额
////        {{amount7.DATA}}
////
////        发放时间
////        {{date8.DATA}}
////
////        温馨提示
////        {{thing9.DATA}}
//        try {
//            WxMaSubscribeMessage wxMaSubscribeMessage = WxMaSubscribeMessage.builder()
//                    .toUser("oJMH34tzjv3UpIkdg6-rG-0vgjGI")
//                    .templateId("TwV2OfrdAXMyWC7rjXjpz_KN-6VWFJuSVGivT9Jrh5A")
////                    .page("填要跳转的详情页面")
//                    .build();
//            Map<String, String> map = new HashMap<>();
//            //活动主题
//            map.put("thing1", "测试活动");
//            //奖品名称
//            map.put("thing10", "奖励金");
//            //到账金额
//            map.put("amount7", "10");
//            //发放时间
//            map.put("date8", "2022-11-25");
//            //温馨提示
//            map.put("thing9", "最终解释权归厂家所有");
//            // 设置将推送的消息
//            map.forEach( (k,v)-> { wxMaSubscribeMessage.addData(new WxMaSubscribeMessage.MsgData(k, v));} );
//            this.wxMaService.getMsgService().sendSubscribeMsg(wxMaSubscribeMessage);
//            return Result.ok();
//        } catch (Exception e) {
//          e.printStackTrace();
//            return Result.error(e.getMessage());
//        }
//    }
}
