package com.biz.crm.member.admin.web.dataview;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 会员信息列表
 * @author zouhs
 * @date 2023/6/19
 */
@Component
public class MemberInfoDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return this.getClass().getSimpleName();
  }

  @Override
  public String desc() {
    return "member-团购会员信息视图";
  }

  @Override
  public String buildSql() {
    return "select "
        + " t1.active_status,"
        + " t1.approval_code,"
        + " t1.approval_date,"
        + " t1.approval_name,"
        + " t1.approval_reject_desc,"
        + " t1.approval_status,"
        + " t1.department,"
        + " t1.industry_code,"
        + " t1.industry_name,"
        + " t1.invite_member_code,"
        + " t1.invite_member_name,"
        + " t1.invite_member_register,"
        + " t1.invite_num,"
        + " t1.last_login_date,"
        + " t1.link_tasting_code,"
        + " t1.link_tasting_name,"
        + " t1.link_tasting_phone,"
        + " t1.member_birthday,"
        + " t1.member_code,"
        + " t1.member_name,"
        + " t1.member_nick,"
        + " t1.member_phone,"
        + " t1.member_register,"
        + " t2.benefits_num,"
        + " t2.big_wheel_prizes,"
        + " t2.current_grow,"
        + " t2.current_integral,"
        + " t2.level_code,"
        + " t2.level_name,"
        + " t2.member_code,"
        + " t2.stay_benefits_num,"
        + " t2.stay_big_wheel_prizes,"
        + " t2.stay_tasting_benefits_num,"
        + " t2.tasting_benefits_num,"
        + " t2.total_grow,"
        + " t2.total_integral,"
        + " t3.city_code,"
        + " t3.city_name,"
        + " t3.district_code,"
        + " t3.district_name,"
        + " t3.email,"
        + " t3.latitude,"
        + " t3.license_firm_name,"
        + " t3.license_image_path,"
        + " t3.license_person_card,"
        + " t3.license_person_name,"
        + " t3.license_register_number,"
        + " t3.longitude,"
        + " t3.member_code,"
        + " t3.open_account_time,"
        + " t3.org_code,"
        + " t3.org_name,"
        + " t3.province_code,"
        + " t3.province_name,"
        + " t3.shop_image_path,"
        + " t3.terminal_address,"
        + " t3.terminal_code,"
        + " t3.terminal_connect,"
        + " t3.terminal_name,"
        + " t3.terminal_phone,"
        + " t3.terminal_type,"
        + " t3.township_name,"
        + " t3.zip_code,"
        + " t4.contact_main,"
        + " t4.contact_name,"
        + " t4.contact_phone,"
        + " t4.role_code,"
        + " t4.role_name,"
        + " t5.org_code,"
        + " t5.org_name,"
        + " t5.supply_code,"
        + " t5.supply_name"
        + "from mms_member_info t1 "
        + "left join mms_member_info_assets t2 on t1.member_code = t2.member_code "
        + "left join mms_member_info_archives t3 on t1.member_code = t3.member_code "
        + "left join mms_member_info_contact t4 on t3.terminal_code = t4.terminal_code "
        + "left join mms_member_info_supply t5 on t3.terminal_code = t5.terminal_code "
        + "where ta.tenant_code = :tenantCode "
        + "and ta.del_flag = '009' "
        + "group by t1.member_code,t3.terminal_code ";
  }
}
