package com.biz.crm.member.admin.web.dataview;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 品鉴顾问数据视图
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/14 10:07
 **/
@Component
public class TastingConsultantDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "member-品鉴顾问数据视图";
    }

    @Override
    public String buildSql() {
        return "select " +
                "ta.id, " +
                "ta.code, " +
                "ta.name, " +
                "ta.phone, " +
                "ta.position, " +
                "ta.birthday, " +
                "ta.company, " +
                "ta.gender, " +
                "GROUP_CONCAT( tr.org_code ) AS 'org_code', " +
                "GROUP_CONCAT( tr.org_name ) AS 'org_name', " +
                "ta.age, " +
                "ta.total_member_num, " +
                "ta.total_growth_value " +
                "from mms_tasting_consultant ta "+
                "left join "+
                "mms_tasting_rel_customer tr on ta.code = tr.tasting_code "+
                "where ta.tenant_code = :tenantCode " +
                "and ta.del_flag = '009' "+
                "group by "+
                "ta.id, " +
                "ta.code, " +
                "ta.name, " +
                "ta.phone, " +
                "ta.position, " +
                "ta.birthday, " +
                "ta.company, " +
                "ta.gender, " +
                "ta.age "+
                "ta.total_member_num, " +
                "ta.total_growth_value ";
    }
}
