package com.biz.crm.member.admin.web.exports.activity.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel(value = "ActivityExportDto",description = "活动导出dto")
@Getter
@Setter
public class ActivityExportDto {

  @ApiModelProperty(name = "code",notes = "活动编码", value = "活动编码")
  private String code;

  @ApiModelProperty(name = "name",notes = "活动名称", value = "活动名称")
  private String name;

  @ApiModelProperty(name = "applyRequireName",notes = "等级限制", value = "等级限制")
  private String applyRequireName;

  @ApiModelProperty(name = "needApproval",notes = "报名审批", value = "报名审批")
  private String needApproval;

  @ApiModelProperty(name = "activityStatus",notes = "活动状态", value = "活动状态")
  private String activityStatus;

  @ApiModelProperty("报名时间（开始）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date applyStartDate;

  @ApiModelProperty("报名结束（结束）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date applyEndDate;

  @ApiModelProperty("签到时间（开始）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signStartDate;

  @ApiModelProperty("签到结束（结束）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signEndDate;

  @ApiModelProperty("启禁用")
  private String enableStatus;

  /**
   * 偏移量
   */
  private Integer offset;

  /**
   * limit
   */
  private Integer limit;
}
