package com.biz.crm.member.admin.web.exports.activity.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 *@description: 活动导出vo
*@Time:2023/7/3 14:26
*/
@CrmExcelExport
@Data
public class ActivityExportVo extends CrmExcelVo {


  /**
   * 活动编码
   */
  @CrmExcelColumn("活动编码")
  private String code;

  /**
   * 活动名称
   */
  @CrmExcelColumn("活动名称")
  private String name;

  /**
   * 等级限制
   */
  @CrmExcelColumn("等级限制")
  private String applyRequireName;

  /**
   * 活动地址
   */
  @CrmExcelColumn("活动地址")
  private String address;

  /**
   * 报名是否需要审批
   */
  @CrmExcelColumn("报名是否需要审批")
  private String needApproval;

  /**
   * 报名时间
   */
  @CrmExcelColumn("报名时间")
  private String applyDateStr;

  /**
   * 签到时间
   */
  @CrmExcelColumn("签到时间")
  private String signDateStr;

  /**
   * 活动状态
   */
  @CrmExcelColumn("活动状态")
  private String activityStatus;

  /**
   * 报名人数上限
   */
  @CrmExcelColumn("报名人数上限")
  private Integer applyCeilingNum;

  /**
   * 报名人数上限
   */
  @CrmExcelColumn("报名人数")
  private String signNum;

  /**
   * 签到人数
   */
  @CrmExcelColumn("签到人数")
  private String attendNum;

  /**
   * 启禁用
   */
  @CrmExcelColumn("启禁用")
  private String enableStatus;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建人")
  private String createName;

  /**
   * 创建人
   */
  @CrmExcelColumn("创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 更新人
   */
  @CrmExcelColumn("更新人")
  private String modifyName;

  /**
   * 更新时间
   */
  @CrmExcelColumn("更新时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
}
