package com.biz.crm.member.admin.web.exports.activity.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.member.admin.web.exports.activity.mapper.ActivityExportMapper;
import com.biz.crm.member.admin.web.exports.activity.model.ActivityExportDto;
import com.biz.crm.member.admin.web.exports.activity.model.ActivityExportVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class ActivityExportProcess implements ExportProcess<CrmExcelVo> {

  @Autowired
  ActivityExportMapper activityExportMapper;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    ActivityExportDto dto = this.convertParams(params);
    return activityExportMapper.getExportTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    ActivityExportDto dto = this.convertParams(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    List<ActivityExportVo> data = activityExportMapper.findData(dto);
    //编码转义
    data.forEach(x->
      x.setEnableStatus(ObjectUtils.defaultIfNull(x.getEnableStatus(), EnableStatusEnum.DISABLE.getCode()).equals(EnableStatusEnum.ENABLE.getCode())?"启用":"禁用"));
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public String getBusinessCode() {
    return "MMS_ACTIVITY_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "活动管理导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private ActivityExportDto convertParams(Map<String, Object> params) {
    return JSON.parseObject(JSON.toJSONString(params), ActivityExportDto.class);
  }
}
