package com.biz.crm.member.admin.web.exports.productCategory.model;


import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
@CrmExcelExport
public class ProductCategoryExportsVo extends CrmExcelVo {

    /** 分类编码 */
    @CrmExcelColumn("分类编码")
    private String categoryCode;

    /** 分类名称 */
    @CrmExcelColumn("分类名称")
    private String categoryName;

    /** 排序 */
    @CrmExcelColumn("排序")
    private Integer sortIndex;

    /**
     * 数据业务状态（启用状态）
     */
    @CrmExcelColumn("启用状态")
    private String enableStatus;

    /** 创建时间 */
    @CrmExcelColumn("创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 创建人名称 */
    @CrmExcelColumn("创建人")
    private String createName;

    /** 修改时间 */
    @CrmExcelColumn("最近更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;

    /** 修改人名称 */
    @CrmExcelColumn("最近更新人")
    private String modifyName;
}
