package com.biz.crm.member.admin.web.exports.productCategory.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.member.admin.web.exports.productCategory.mapper.ProductCategoryExportsMapper;
import com.biz.crm.member.admin.web.exports.productCategory.model.ProductCategoryExportsDto;
import com.biz.crm.member.admin.web.exports.productCategory.model.ProductCategoryExportsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class ProductCategoryExportsProcess implements ExportProcess<ProductCategoryExportsVo> {


    @Autowired
    private ProductCategoryExportsMapper incomeBudgetExportsMapper;


    @Override
    public Integer getTotal(Map<String, Object> params) {
        ProductCategoryExportsDto dto = this.findDataDto(params);
        return incomeBudgetExportsMapper.getExportTotal(dto);
    }


    /**
     * 获取参数，封装dto
     * @param params
     * @return
     */
    private ProductCategoryExportsDto findDataDto(Map<String, Object> params) {



       return BeanUtil.toBean(params, ProductCategoryExportsDto.class);

    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        final ProductCategoryExportsDto dto = this.findDataDto(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<ProductCategoryExportsVo> data = incomeBudgetExportsMapper.findData(dto);
        return JSON.parseArray(JSON.toJSONString(data));

    }

    @Override
    public Class<ProductCategoryExportsVo> findCrmExcelVoClass() {
        return ProductCategoryExportsVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "member_product_category_export";
    }

    @Override
    public String getBusinessName() {
        return "商品分类导出";
    }
}
