package com.biz.crm.member.admin.web.imports.realOrder.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.member.admin.web.imports.realOrder.model.RealOrderImportVo;
import com.biz.crm.member.business.member.local.service.RealOrderService;
import com.biz.crm.member.business.member.sdk.vo.RealOrderVo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 实物订单导入
 * @author zouhs
 * @date 2022/12/1
 */
@Component
public class RealOrderImportProcess implements ImportProcess<RealOrderImportVo> {

  @Autowired
  private RealOrderService realOrderService;

  @Override
  public Integer getBatchCount() {
    return Integer.MAX_VALUE;
  }

  @Override
  public Map<Integer, String> execute(LinkedHashMap<Integer, RealOrderImportVo> data,
      TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
    final Optional<RealOrderImportVo> first = data.values().stream().findFirst();
    if (!first.isPresent()) {
      return null;
    }
    RealOrderImportVo vo = first.get();
    this.validate(vo);
    RealOrderVo realOrderVo = new RealOrderVo();
    realOrderVo.setOrderCode(vo.getOrderCode());
    realOrderVo.setExpressNum(vo.getExpressNum());
    realOrderService.realOrderImportExpressNum(realOrderVo);
    return null;
  }

  private void validate(RealOrderImportVo vo) {
    Validate.notBlank(vo.getOrderCode(),"订单号不能为空");
    Validate.notBlank(vo.getExpressNum(),"快递号不能为空");
  }

  @Override
  public Class<RealOrderImportVo> findCrmExcelVoClass() {
    return RealOrderImportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MMS_REAL_ORDER_EXPRESS_NUM_IMPORT";
  }

  @Override
  public String getBusinessName() {
    return "MMS会员实物订单物流信息导入";
  }

  @Override
  public String getTemplateCode() {
    return "MMS_REAL_ORDER_EXPRESS_NUM_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "MMS会员实物订单物流信息导入";
  }
}
